/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.BiomeHelper;
import forestry.api.core.IErrorLogic;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TileBase;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.inventory.InventoryRaintank;
import java.io.IOException;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileRaintank
extends TileBase
implements ISidedInventory,
ILiquidTankTile,
IFluidHandler {
    private static final FluidStack STACK_WATER = Fluids.WATER.getFluid(10);
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private boolean isValidBiome = true;
    private int fillingTime;
    private ItemStack usedEmpty;

    public TileRaintank() {
        super(GuiId.RaintankGUI, "raintank");
        this.setInternalInventory(new InventoryRaintank(this));
        this.resourceTank = new FilteredTank(30000, FluidRegistry.WATER);
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    public void validate() {
        if (this.worldObj != null) {
            BiomeGenBase biome = this.worldObj.getBiomeGenForCoordsBody(this.xCoord, this.zCoord);
            this.isValidBiome = BiomeHelper.canRainOrSnow(biome);
            this.getErrorLogic().setCondition(!this.isValidBiome, EnumErrorCode.NO_RAIN_BIOME);
        }
        super.validate();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("IsValidBiome", this.isValidBiome);
        this.tankManager.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.isValidBiome = nbttagcompound.getBoolean("IsValidBiome");
        this.tankManager.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        if (!this.updateOnInterval(20)) {
            return;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!this.isValidBiome, EnumErrorCode.NO_RAIN_BIOME);
        boolean hasSky = this.worldObj.canBlockSeeTheSky(this.xCoord, this.yCoord + 1, this.zCoord);
        errorLogic.setCondition(!hasSky, EnumErrorCode.NO_SKY_RAIN_TANK);
        errorLogic.setCondition(!this.worldObj.isRaining(), EnumErrorCode.NOT_RAINING);
        if (!errorLogic.hasErrors()) {
            this.resourceTank.fill(STACK_WATER, true);
        }
        if (!ItemStackUtil.isIdenticalItem(this.usedEmpty, this.getStackInSlot(0))) {
            this.fillingTime = 0;
            this.usedEmpty = null;
        }
        if (this.usedEmpty == null) {
            this.usedEmpty = this.getStackInSlot(0);
        }
        if (!this.isFilling()) {
            FluidHelper.FillStatus canFill = FluidHelper.fillContainers(this.tankManager, (IInventory)this, 0, 1, Fluids.WATER.getFluid(), false);
            if (canFill == FluidHelper.FillStatus.SUCCESS) {
                this.fillingTime = 12;
            }
        } else {
            FluidHelper.FillStatus filled;
            --this.fillingTime;
            if (this.fillingTime <= 0 && (filled = FluidHelper.fillContainers(this.tankManager, (IInventory)this, 0, 1, Fluids.WATER.getFluid())) == FluidHelper.FillStatus.SUCCESS) {
                this.fillingTime = 0;
            }
        }
    }

    public boolean isFilling() {
        return this.fillingTime > 0;
    }

    public int getFillProgressScaled(int i) {
        return this.fillingTime * i / 12;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.fillingTime = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.sendProgressBarUpdate(container, 0, this.fillingTime);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }
}

