/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.network;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IPacketId;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketIdClient;
import forestry.core.proxy.Proxies;
import forestry.factory.recipes.MemorizedRecipe;
import forestry.factory.tiles.TileWorktable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketWorktableRecipeUpdate
extends PacketCoordinates
implements IForestryPacketClient {
    private MemorizedRecipe recipe;

    public PacketWorktableRecipeUpdate() {
    }

    public PacketWorktableRecipeUpdate(TileWorktable worktable) {
        super((IPacketId)PacketIdClient.WORKTABLE_CRAFTING_UPDATE, worktable);
        this.recipe = worktable.getCurrentRecipe();
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeStreamable(this.recipe);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.recipe = data.readStreamable(MemorizedRecipe.class);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof TileWorktable) {
            ((TileWorktable)tile).setCurrentRecipe(this.recipe);
        }
    }
}

