/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.buttons.GuiBetterButton;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.network.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.factory.gui.ContainerWorktable;
import forestry.factory.gui.widgets.ClearWorktable;
import forestry.factory.gui.widgets.MemorizedRecipeSlot;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.TileWorktable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;

public class GuiWorktable
extends GuiForestryTitled<ContainerWorktable, TileWorktable> {
    private static final int SPACING = 18;
    private boolean hasRecipeConflict = false;

    public GuiWorktable(EntityPlayer player, TileWorktable tile) {
        super("textures/gui/worktable2.png", new ContainerWorktable(player, tile), tile);
        this.ySize = 218;
        RecipeMemory recipeMemory = tile.getMemory();
        int slot = 0;
        for (int y = 0; y < 3; ++y) {
            int yPos = 20 + y * 18;
            for (int x = 0; x < 3; ++x) {
                int xPos = 110 + x * 18;
                MemorizedRecipeSlot memorizedRecipeSlot = new MemorizedRecipeSlot(this.widgetManager, xPos, yPos, recipeMemory, slot++);
                this.widgetManager.add(memorizedRecipeSlot);
            }
        }
        this.widgetManager.add(new ClearWorktable(this.widgetManager, 66, 19));
    }

    public void updateScreen() {
        super.updateScreen();
        if (this.hasRecipeConflict != ((TileWorktable)this.inventory).hasRecipeConflict()) {
            this.hasRecipeConflict = ((TileWorktable)this.inventory).hasRecipeConflict();
            if (this.hasRecipeConflict) {
                this.addButtons();
            } else {
                this.buttonList.clear();
            }
        }
    }

    private void addButtons() {
        this.buttonList.add(new GuiBetterButton(0, this.guiLeft + 76, this.guiTop + 56, StandardButtonTextureSets.LEFT_BUTTON_SMALL));
        this.buttonList.add(new GuiBetterButton(1, this.guiLeft + 85, this.guiTop + 56, StandardButtonTextureSets.RIGHT_BUTTON_SMALL));
    }

    protected void actionPerformed(GuiButton button) {
        int id = 100 + button.id;
        Proxies.net.sendToServer(new PacketGuiSelectRequest(id, 0));
    }
}

