/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.ContainerTile;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotFiltered;
import forestry.core.gui.slots.SlotOutput;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.network.IStreamableGui;
import forestry.core.network.PacketGuiSelectRequest;
import forestry.core.network.PacketGuiUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.TileEscritoire;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;

public class ContainerEscritoire
extends ContainerTile<TileEscritoire>
implements IGuiSelectable {
    private final EntityPlayer player;
    private long lastUpdate;

    public ContainerEscritoire(EntityPlayer player, TileEscritoire tile) {
        super(tile, player.inventory, 34, 153);
        int i;
        this.player = player;
        this.addSlotToContainer(new SlotFiltered((IInventory)this.tile, 0, 97, 67).setPickupWatcher((ISlotPickupWatcher)this.tile).setStackLimit(1));
        for (i = 0; i < 5; ++i) {
            this.addSlotToContainer(new SlotFiltered((IInventory)this.tile, 7 + i, 17, 49 + i * 18).setBlockedTexture("slots/blocked_2"));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlotToContainer(new SlotOutput((IInventory)this.tile, 1 + i * 2 + j, 177 + j * 18, 85 + i * 18));
            }
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        long gameLastUpdate = ((TileEscritoire)this.tile).getGame().getLastUpdate();
        if (this.lastUpdate != gameLastUpdate) {
            this.lastUpdate = gameLastUpdate;
            Proxies.net.sendToPlayer(new PacketGuiUpdate((IStreamableGui)this.tile), this.player);
        }
    }

    @Override
    public void handleSelectionRequest(EntityPlayerMP player, PacketGuiSelectRequest packet) {
        EscritoireGame.Status status = ((TileEscritoire)this.tile).getGame().getStatus();
        if (status != EscritoireGame.Status.PLAYING) {
            return;
        }
        int index = packet.getPrimaryIndex();
        if (index == -1) {
            ((TileEscritoire)this.tile).probe();
        } else {
            ((TileEscritoire)this.tile).choose(player.getGameProfile(), index);
        }
    }
}

