/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.inventory;

import forestry.apiculture.multiblock.TileAlvearySieve;
import forestry.core.config.ForestryItem;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.utils.ItemStackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class InventoryAlvearySieve
extends InventoryAdapterTile<TileAlvearySieve>
implements ISlotPickupWatcher {
    public static final int SLOT_POLLEN_1 = 0;
    public static final int SLOTS_POLLEN_COUNT = 4;
    public static final int SLOT_SIEVE = 4;

    public InventoryAlvearySieve(TileAlvearySieve alvearySieve) {
        super(alvearySieve, 5, "Items", 1);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return ItemStackUtil.isIdenticalItem(ForestryItem.craftingMaterial.getItemStack(1, 3), itemStack);
    }

    public boolean canStorePollen() {
        if (this.getStackInSlot(4) == null) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.getStackInSlot(i) != null) continue;
            return true;
        }
        return false;
    }

    public void storePollenStack(ItemStack itemstack) {
        for (int i = 0; i < 4; ++i) {
            if (this.getStackInSlot(i) != null) continue;
            this.setInventorySlotContents(i, itemstack);
            return;
        }
    }

    @Override
    public void onPickupFromSlot(int slotIndex, EntityPlayer player) {
        if (slotIndex == 4) {
            for (int i = 0; i < 4; ++i) {
                this.setInventorySlotContents(i, null);
            }
        } else {
            this.setInventorySlotContents(4, null);
        }
    }
}

