/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.api.mail.EnumAddressee;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostOffice;
import forestry.api.mail.IPostalState;
import forestry.api.mail.ITradeStation;
import forestry.api.mail.PostManager;
import forestry.api.mail.TradeStationInfo;
import forestry.core.gui.IGuiSelectable;
import forestry.core.network.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.mail.EnumStationState;
import forestry.mail.gui.ILetterInfoReceiver;
import forestry.mail.network.PacketLetterInfoResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;

public class ContainerCatalogue
extends Container
implements IGuiSelectable,
ILetterInfoReceiver {
    private final EntityPlayer player;
    private final List<ITradeStation> stations = new ArrayList<ITradeStation>();
    private TradeStationInfo currentTrade = null;
    private int stationIndex = 0;
    private int stationCount;
    private boolean needsSynch = true;
    private int currentFilter = 1;
    private static final String[] FILTER_NAMES = new String[]{"all", "online", "offline"};
    private static final List<Set<IPostalState>> FILTERS = new ArrayList<Set<IPostalState>>();

    public ContainerCatalogue(EntityPlayer player) {
        this.player = player;
        if (!player.worldObj.isRemote) {
            this.rebuildStationsList();
        }
    }

    public int getPageCount() {
        return Math.max(this.stationCount, 1);
    }

    public int getPageNumber() {
        return this.stationIndex + 1;
    }

    public String getFilterIdent() {
        return FILTER_NAMES[this.currentFilter];
    }

    private void rebuildStationsList() {
        this.stations.clear();
        IPostOffice postOffice = PostManager.postRegistry.getPostOffice(this.player.worldObj);
        Map<IMailAddress, ITradeStation> tradeStations = postOffice.getActiveTradeStations(this.player.worldObj);
        for (ITradeStation station : tradeStations.values()) {
            TradeStationInfo info = station.getTradeInfo();
            if (info.tradegood == null || !FILTERS.get(this.currentFilter).contains(info.state)) continue;
            this.stations.add(station);
        }
        this.stationIndex = 0;
        this.updateTradeInfo();
    }

    public void nextPage() {
        if (this.player.worldObj.isRemote) {
            ContainerCatalogue.sendSelection(true);
            return;
        }
        if (this.stations.size() == 0) {
            return;
        }
        this.stationIndex = (this.stationIndex + 1) % this.stations.size();
        this.updateTradeInfo();
    }

    public void previousPage() {
        if (this.player.worldObj.isRemote) {
            ContainerCatalogue.sendSelection(false);
            return;
        }
        if (this.stations.size() == 0) {
            return;
        }
        this.stationIndex = (this.stationIndex - 1 + this.stations.size()) % this.stations.size();
        this.updateTradeInfo();
    }

    public void cycleFilter() {
        if (this.player.worldObj.isRemote) {
            Proxies.net.sendToServer(new PacketGuiSelectRequest(2, 0));
            return;
        }
        this.currentFilter = (this.currentFilter + 1) % FILTERS.size();
        this.rebuildStationsList();
    }

    private static void sendSelection(boolean advance) {
        int value = advance ? 0 : 1;
        Proxies.net.sendToServer(new PacketGuiSelectRequest(value, 0));
    }

    private void updateTradeInfo() {
        if (this.player.worldObj.isRemote) {
            return;
        }
        if (!this.stations.isEmpty()) {
            ITradeStation station = this.stations.get(this.stationIndex);
            this.setTradeInfo(station.getTradeInfo());
        } else {
            this.setTradeInfo(null);
        }
        this.needsSynch = true;
    }

    @Override
    public void handleLetterInfoUpdate(PacketLetterInfoResponse packet) {
        this.setTradeInfo(packet.tradeInfo);
    }

    public TradeStationInfo getTradeInfo() {
        return this.currentTrade;
    }

    private void setTradeInfo(TradeStationInfo info) {
        this.currentTrade = info;
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.needsSynch) {
            for (Object crafter1 : this.crafters) {
                ICrafting crafter = (ICrafting)crafter1;
                crafter.sendProgressBarUpdate((Container)this, 0, this.stationIndex);
                crafter.sendProgressBarUpdate((Container)this, 1, this.stations.size());
                crafter.sendProgressBarUpdate((Container)this, 2, this.currentFilter);
            }
            Proxies.net.sendToPlayer(new PacketLetterInfoResponse(EnumAddressee.TRADER, this.currentTrade, null), this.player);
            this.needsSynch = false;
        }
    }

    public void updateProgressBar(int i, int j) {
        switch (i) {
            case 0: {
                this.stationIndex = j;
                break;
            }
            case 1: {
                this.stationCount = j;
                break;
            }
            case 2: {
                this.currentFilter = j;
            }
        }
    }

    public boolean canInteractWith(EntityPlayer p_75145_1_) {
        return true;
    }

    @Override
    public void handleSelectionRequest(EntityPlayerMP player, PacketGuiSelectRequest packet) {
        switch (packet.getPrimaryIndex()) {
            case 0: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
                break;
            }
            case 2: {
                this.cycleFilter();
            }
        }
        this.needsSynch = true;
    }

    static {
        EnumSet<EnumStationState> all = EnumSet.allOf(EnumStationState.class);
        EnumSet<EnumStationState> online = EnumSet.of(EnumStationState.OK);
        EnumSet<EnumStationState> offline = EnumSet.copyOf(all);
        offline.removeAll(online);
        FILTERS.add(Collections.unmodifiableSet(all));
        FILTERS.add(Collections.unmodifiableSet(online));
        FILTERS.add(Collections.unmodifiableSet(offline));
    }
}

