/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IStamps;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.StringUtil;
import forestry.mail.MailAddress;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.StringUtils;

public class Letter
implements ILetter {
    public static final short SLOT_ATTACHMENT_1 = 0;
    public static final short SLOT_ATTACHMENT_COUNT = 18;
    public static final short SLOT_POSTAGE_1 = 18;
    public static final short SLOT_POSTAGE_COUNT = 4;
    private boolean isProcessed = false;
    private IMailAddress sender;
    private IMailAddress[] recipient;
    private String text;
    private final InventoryAdapter inventory = new InventoryAdapter(22, "INV");

    public Letter(IMailAddress sender, IMailAddress recipient) {
        this.sender = sender;
        this.recipient = new IMailAddress[]{recipient};
    }

    public Letter(NBTTagCompound nbttagcompound) {
        if (nbttagcompound != null) {
            this.readFromNBT(nbttagcompound);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.isProcessed = nbttagcompound.getBoolean("PRC");
        this.sender = MailAddress.loadFromNBT(nbttagcompound.getCompoundTag("SDR"));
        int recipientCount = nbttagcompound.getShort("CRC");
        this.recipient = new MailAddress[recipientCount];
        for (int i = 0; i < recipientCount; ++i) {
            this.recipient[i] = MailAddress.loadFromNBT(nbttagcompound.getCompoundTag("RC" + i));
        }
        this.text = nbttagcompound.getString("TXT");
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setBoolean("PRC", this.isProcessed);
        NBTTagCompound subcompound = new NBTTagCompound();
        this.sender.writeToNBT(subcompound);
        nbttagcompound.setTag("SDR", (NBTBase)subcompound);
        nbttagcompound.setShort("CRC", (short)this.recipient.length);
        for (int i = 0; i < this.recipient.length; ++i) {
            subcompound = new NBTTagCompound();
            this.recipient[i].writeToNBT(subcompound);
            nbttagcompound.setTag("RC" + i, (NBTBase)subcompound);
        }
        nbttagcompound.setString("TXT", this.text);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public ItemStack[] getPostage() {
        return InventoryUtil.getStacks((IInventory)this.inventory, 18, 4);
    }

    @Override
    public ItemStack[] getAttachments() {
        return InventoryUtil.getStacks((IInventory)this.inventory, 0, 18);
    }

    @Override
    public int countAttachments() {
        int count = 0;
        for (ItemStack stack : this.getAttachments()) {
            if (stack == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void addAttachment(ItemStack itemstack) {
        InventoryUtil.tryAddStack((IInventory)this.inventory, itemstack, false);
    }

    @Override
    public void addAttachments(ItemStack[] itemstacks) {
        for (ItemStack stack : itemstacks) {
            this.addAttachment(stack);
        }
    }

    @Override
    public void invalidatePostage() {
        for (int i = 18; i < 22; ++i) {
            this.inventory.setInventorySlotContents(i, null);
        }
    }

    @Override
    public void setProcessed(boolean flag) {
        this.isProcessed = flag;
    }

    @Override
    public boolean isProcessed() {
        return this.isProcessed;
    }

    @Override
    public boolean isMailable() {
        return !this.isProcessed && this.recipient != null && this.recipient.length > 0;
    }

    @Override
    public boolean isPostPaid() {
        int posted = 0;
        for (ItemStack stamp : this.getPostage()) {
            if (stamp == null || !(stamp.getItem() instanceof IStamps)) continue;
            posted += ((IStamps)stamp.getItem()).getPostage(stamp).getValue() * stamp.stackSize;
        }
        return posted >= this.requiredPostage();
    }

    @Override
    public int requiredPostage() {
        int required = 1;
        for (ItemStack attach : this.getAttachments()) {
            if (attach == null) continue;
            ++required;
        }
        return required;
    }

    @Override
    public void addStamps(ItemStack stamps) {
        InventoryUtil.tryAddStack((IInventory)this.inventory, stamps, 18, 4, false);
    }

    @Override
    public boolean hasRecipient() {
        if (this.getRecipients().length <= 0) {
            return false;
        }
        IMailAddress recipient = this.getRecipients()[0];
        if (recipient == null) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)recipient.getName());
    }

    @Override
    public void setSender(IMailAddress address) {
        this.sender = address;
    }

    @Override
    public IMailAddress getSender() {
        return this.sender;
    }

    @Override
    public void setRecipient(IMailAddress address) {
        this.recipient = address == null ? new IMailAddress[0] : new IMailAddress[]{address};
    }

    @Override
    public IMailAddress[] getRecipients() {
        return this.recipient;
    }

    @Override
    public String getRecipientString() {
        StringBuilder recipientString = new StringBuilder();
        for (IMailAddress address : this.recipient) {
            if (recipientString.length() > 0) {
                recipientString.append(", ");
            }
            recipientString.append(address.getName());
        }
        return recipientString.toString();
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.sender != null && StringUtils.isNotBlank((CharSequence)this.sender.getName())) {
            list.add(StringUtil.localize("gui.mail.from") + ": " + this.sender.getName());
        }
        if (this.recipient != null && this.recipient.length > 0) {
            list.add(StringUtil.localize("gui.mail.to") + ": " + this.getRecipientString());
        }
    }

    public int getSizeInventory() {
        return this.inventory.getSizeInventory();
    }

    public ItemStack getStackInSlot(int var1) {
        return this.inventory.getStackInSlot(var1);
    }

    public ItemStack decrStackSize(int var1, int var2) {
        return this.inventory.decrStackSize(var1, var2);
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return this.inventory.getStackInSlotOnClosing(var1);
    }

    public void setInventorySlotContents(int var1, ItemStack var2) {
        this.inventory.setInventorySlotContents(var1, var2);
    }

    public String getInventoryName() {
        return this.inventory.getInventoryName();
    }

    public int getInventoryStackLimit() {
        return this.inventory.getInventoryStackLimit();
    }

    public void markDirty() {
        this.inventory.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return true;
    }

    public void openInventory() {
        this.inventory.openInventory();
    }

    public void closeInventory() {
        this.inventory.closeInventory();
    }

    public boolean hasCustomInventoryName() {
        return this.inventory.hasCustomInventoryName();
    }

    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return this.inventory.isItemValidForSlot(i, itemstack);
    }
}

