/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.Farmables;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ModUtil;
import forestry.farming.logic.FarmableBasicFruit;
import forestry.farming.logic.FarmableGenericCrop;
import forestry.farming.logic.FarmableStacked;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="PlantMegaPack", name="PlantMegaPack", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.plantmegapack.description")
public class PluginPlantMegaPack
extends ForestryPlugin {
    private static final String PlantMP = "plantmegapack";

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(PlantMP);
    }

    @Override
    public String getFailMessage() {
        return "Plant Mega Pack not found";
    }

    @Override
    protected void registerRecipes() {
        ItemStack foodStack;
        ImmutableList reedLikePlant = ImmutableList.of((Object)"bambooAsper", (Object)"bambooFargesiaRobusta", (Object)"bambooGiantTimber", (Object)"bambooGolden", (Object)"bambooMoso", (Object)"bambooShortTassled", (Object)"bambooTimorBlack", (Object)"bambooTropicalBlue", (Object)"bambooWetForest");
        ImmutableList landCropPlant = ImmutableList.of((Object)"Beet", (Object)"BellPepperYellow", (Object)"Celery", (Object)"Corn", (Object)"Cucumber", (Object)"Lettuce", (Object)"Onion", (Object)"Spinach", (Object)"Tomato");
        ImmutableMap desertPlant = ImmutableMap.builder().put((Object)"cactusArmatocereusMatucanensis", (Object)6).put((Object)"cactusBaseballBat", (Object)6).put((Object)"cactusEchinocereusMetornii", (Object)2).put((Object)"cactusGoldenCereus", (Object)3).put((Object)"cactusGoldenSaguaro", (Object)6).put((Object)"cactusMatucanaAureiflora", (Object)1).put((Object)"cactusPricklyPear", (Object)5).put((Object)"cactusSnowPole", (Object)6).put((Object)"cactusToothpick", (Object)6).put((Object)"desertApachePlume", (Object)4).put((Object)"desertBrittlebush", (Object)4).put((Object)"desertBroadLeafGilia", (Object)4).put((Object)"desertBroomSnakeweed", (Object)4).put((Object)"desertKangarooPaw", (Object)4).put((Object)"desertOcotillo", (Object)4).put((Object)"desertPeninsulaOnion", (Object)4).put((Object)"desertSeepwood", (Object)4).put((Object)"desertWhiteSage", (Object)4).build();
        ImmutableMap nonGrowingFlowers = ImmutableMap.builder().put((Object)"flowerAchillea", (Object)9).put((Object)"flowerAlpineThistle", (Object)1).put((Object)"flowerAzalea", (Object)13).put((Object)"flowerBegonia", (Object)9).put((Object)"flowerBell", (Object)10).put((Object)"flowerBirdofParadise", (Object)1).put((Object)"flowerBlueStar", (Object)1).put((Object)"flowerBurningLove", (Object)1).put((Object)"flowerCandelabraAloe", (Object)1).put((Object)"flowerCarnation", (Object)7).put((Object)"flowerCelosia", (Object)7).put((Object)"flowerDahlia", (Object)8).put((Object)"flowerDaisy", (Object)8).put((Object)"flowerDelphinium", (Object)4).put((Object)"flowerDottedBlazingstar", (Object)1).put((Object)"flowerElephantEars", (Object)1).put((Object)"flowerFoamFlower", (Object)1).put((Object)"flowerFuchsia", (Object)1).put((Object)"flowerGeranium", (Object)5).put((Object)"flowerGladiolus", (Object)9).put((Object)"flowerHawkweed", (Object)4).put((Object)"flowerHydrangea", (Object)6).put((Object)"flowerJacobsLadder", (Object)1).put((Object)"flowerLily", (Object)5).put((Object)"flowerLionsTail", (Object)1).put((Object)"flowerLupine", (Object)10).put((Object)"flowerMarigold", (Object)2).put((Object)"flowerMediterraneanSeaHolly", (Object)1).put((Object)"flowerNemesia", (Object)12).put((Object)"flowerNewGuineaImpatiens", (Object)1).put((Object)"flowerParrotsBeak", (Object)1).put((Object)"flowerPeruvianLily", (Object)1).put((Object)"flowerPurpleConeflower", (Object)1).put((Object)"flowerRose", (Object)13).put((Object)"flowerRoseCampion", (Object)1).put((Object)"flowerStreamsideBluebells", (Object)1).put((Object)"flowerTorchLily", (Object)1).put((Object)"flowerTulip", (Object)7).put((Object)"flowerViolet", (Object)1).put((Object)"flowerWildCarrot", (Object)1).put((Object)"flowerWildDaffodil", (Object)1).put((Object)"flowerWoodlandPinkroot", (Object)1).put((Object)"flowerYellowToadflax", (Object)1).put((Object)"floatingWaterHyacinth", (Object)1).put((Object)"floatingWaterLily", (Object)13).build();
        ImmutableMap floatingWaterPlant = ImmutableMap.builder().put((Object)"cropSacredLotus", (Object)4).put((Object)"cropWatercress", (Object)4).put((Object)"cropTaro", (Object)4).put((Object)"cropWasabi", (Object)4).put((Object)"cropLaksaLeaf", (Object)4).put((Object)"cropCentella", (Object)4).put((Object)"cropRice", (Object)4).put((Object)"cropWaterSpinach", (Object)4).put((Object)"cropWildRice", (Object)4).put((Object)"immersedArrowArum", (Object)4).put((Object)"immersedCommonReed", (Object)4).put((Object)"immersedDuckPotato", (Object)4).put((Object)"immersedEuropeanBurReed", (Object)4).put((Object)"immersedGreySedge", (Object)4).put((Object)"immersedSimplestemBurReed", (Object)4).put((Object)"immersedSoftstemBulrush", (Object)4).put((Object)"immersedWaterMannagrass", (Object)4).put((Object)"immersedYellowFlag", (Object)4).build();
        ImmutableMap fungusPlant = ImmutableMap.builder().put((Object)"fungusBlackPowderpuff", (Object)1).put((Object)"fungusChanterelle", (Object)1).put((Object)"fungusGiantClub", (Object)1).put((Object)"fungusParasol", (Object)2).put((Object)"fungusStinkhorn", (Object)1).put((Object)"fungusWeepingMilkCap", (Object)1).put((Object)"fungusWoodBlewit", (Object)1).build();
        ImmutableMap junglePlant = ImmutableMap.builder().put((Object)"jungleConeHeadedGuzmania", (Object)2).put((Object)"jungleDevilsTongue", (Object)6).put((Object)"jungleHoneySpurge", (Object)1).put((Object)"jungleJungleLantern", (Object)6).put((Object)"jungleLazarusBell", (Object)2).put((Object)"jungleLobsterClaws", (Object)6).put((Object)"jungleLollipopPlant", (Object)2).put((Object)"jungleMadagascarPalm", (Object)6).put((Object)"junglePalmLily", (Object)6).put((Object)"junglePanamaQueen", (Object)2).put((Object)"junglePorteaAlatisepala", (Object)2).put((Object)"jungleRacinaeaFraseri", (Object)6).put((Object)"jungleRicheaDracophylla", (Object)2).put((Object)"jungleSilverVase", (Object)2).put((Object)"jungleStaghornClubmoss", (Object)2).put((Object)"jungleTorchGinger", (Object)2).put((Object)"jungleVoodooLily", (Object)6).put((Object)"leafyEmeraldPhilodendron", (Object)2).build();
        ImmutableMap vanillaPlant = ImmutableMap.builder().put((Object)"beachHighTideBush", (Object)6).put((Object)"beachSeaLavender", (Object)4).put((Object)"beachSeaSandwort", (Object)4).put((Object)"leafyDustyMiller", (Object)1).put((Object)"fernCretanBrake", (Object)1).put((Object)"fernHayScented", (Object)2).put((Object)"fernKangaroo", (Object)2).put((Object)"fernMaidenhairSpleenwort", (Object)3).put((Object)"fernOstrich", (Object)6).put((Object)"fernScalyTree", (Object)6).put((Object)"fernSword", (Object)6).put((Object)"fernWoodsia", (Object)2).put((Object)"forestArcticGentian", (Object)1).put((Object)"forestAustralianBugle", (Object)2).put((Object)"forestBroadleafMeadowsweet", (Object)2).put((Object)"forestDeadnettle", (Object)2).put((Object)"forestDeceivingTrillium", (Object)2).put((Object)"forestFairySlipper", (Object)2).put((Object)"forestHorseweed", (Object)2).put((Object)"forestKneelingAngelica", (Object)2).put((Object)"forestNorthernPitcherPlant", (Object)2).put((Object)"forestPinesap", (Object)2).put((Object)"forestRedHelleborine", (Object)2).put((Object)"forestSalal", (Object)2).put((Object)"forestVanillaLeaf", (Object)1).put((Object)"forestWesternWallflower", (Object)2).put((Object)"forestWildColumbine", (Object)2).put((Object)"forestWildMint", (Object)2).put((Object)"forestWolfsFootClubmoss", (Object)1).put((Object)"leafyColeus", (Object)1).put((Object)"leafyStonecrop", (Object)1).put((Object)"grassBlueWheatgrass", (Object)1).put((Object)"grassCord", (Object)6).put((Object)"grassFountain", (Object)2).put((Object)"grassMeadow", (Object)2).put((Object)"grassMeadowFoxtail", (Object)1).put((Object)"grassPrairie", (Object)1).put((Object)"grassSilverMoor", (Object)2).put((Object)"grassSwitch", (Object)6).put((Object)"mountainAlpineArmeria", (Object)2).put((Object)"mountainAlpineBellflower", (Object)2).put((Object)"mountainBistort", (Object)2).put((Object)"mountainEdelweiss", (Object)2).put((Object)"mountainHouseleek", (Object)2).put((Object)"mountainIris", (Object)1).put((Object)"mountainNorthernWillowherb", (Object)2).put((Object)"mountainScarletTrumpet", (Object)2).put((Object)"mountainYellowBellflower", (Object)1).put((Object)"leafyKrisPlant", (Object)2).put((Object)"plainsPrairieBrome", (Object)6).put((Object)"plainsPrairieSage", (Object)4).put((Object)"plainsReedCanaryGrass", (Object)6).put((Object)"plainsShortrayFleabane", (Object)4).put((Object)"plainsSmallPasqueFlower", (Object)4).put((Object)"plainsSmoothAster", (Object)4).put((Object)"plainsThreeFloweredAvens", (Object)4).put((Object)"leafyPricklyLettuce", (Object)1).put((Object)"savannaButterflyWeed", (Object)2).put((Object)"savannaHoaryVervain", (Object)2).put((Object)"savannaLeadplant", (Object)2).put((Object)"savannaMarcela", (Object)2).put((Object)"savannaNorthernBedstraw", (Object)1).put((Object)"savannaPiersonsMilkVetch", (Object)2).put((Object)"savannaPropellerPlant", (Object)2).put((Object)"savannaShonaCabbage", (Object)2).put((Object)"savannaTexasTickseed", (Object)2).put((Object)"leafyPaleYucca", (Object)2).put((Object)"leafyDevilsShoestring", (Object)2).put((Object)"shrubAlpineCurrant", (Object)2).put((Object)"shrubBarberry", (Object)2).put((Object)"shrubBoxwood", (Object)2).put((Object)"shrubButterfly", (Object)2).put((Object)"shrubCanyonCreekAbelia", (Object)2).put((Object)"shrubCapeJasmine", (Object)2).put((Object)"shrubCedarCylinder", (Object)6).put((Object)"shrubCedarGlobe", (Object)2).put((Object)"shrubCedarPyramid", (Object)6).put((Object)"shrubCypressGreen", (Object)1).put((Object)"shrubCypressYellow", (Object)1).put((Object)"shrubDaphne", (Object)2).put((Object)"shrubHolly", (Object)2).put((Object)"shrubHummingbirdBush", (Object)2).put((Object)"shrubJuniperSavin", (Object)2).put((Object)"shrubKerria", (Object)2).put((Object)"shrubLavender", (Object)2).put((Object)"shrubLindera", (Object)3).put((Object)"shrubMeadowsweet", (Object)2).put((Object)"shrubMottlecah", (Object)2).put((Object)"shrubNinebark", (Object)2).put((Object)"shrubSargentViburnum", (Object)2).put((Object)"shrubWeepingForsythia", (Object)2).put((Object)"shrubWinterberry", (Object)2).put((Object)"shrubWolfWillow", (Object)2).put((Object)"wetlandsCattails", (Object)6).put((Object)"wetlandsClubrush", (Object)2).put((Object)"wetlandsCommonRush", (Object)2).put((Object)"wetlandsFloweringRush", (Object)2).put((Object)"wetlandsPickerelweed", (Object)2).put((Object)"wetlandsReedMannagrass", (Object)2).put((Object)"wetlandsSwampMilkweed", (Object)2).put((Object)"wetlandsWaterHorsetail", (Object)1).put((Object)"wetlandsWhiteTurtlehead", (Object)2).build();
        ImmutableMap berryBushPlant = ImmutableMap.builder().put((Object)"Beauty", (Object)4).put((Object)"Black", (Object)4).put((Object)"Blue", (Object)4).put((Object)"Elder", (Object)4).put((Object)"Goose", (Object)4).put((Object)"Huckle", (Object)4).put((Object)"Orange", (Object)4).put((Object)"Snow", (Object)4).put((Object)"Straw", (Object)4).build();
        ImmutableList waterPlant = ImmutableList.of((Object)"oceanCommonEelgrass", (Object)"oceanCoralWeed", (Object)"oceanMozuku", (Object)"oceanRockweed", (Object)"oceanSeaGrapes", (Object)"oceanSeaLettuce", (Object)"oceanTangle", (Object)"riverAmazonSword", (Object)"riverCanadianWaterweed", (Object)"riverCoonsTail", (Object)"riverEelgrass", (Object)"riverWaterWisteria", (Object[])new String[]{"riverWrightsWaternymph", "waterKelpGiantGRN", "waterKelpGiantYEL"});
        ImmutableMap specialCaseTwoTall = ImmutableMap.builder().put((Object)"grassSeaOats", (Object)"flowersVanilla").put((Object)"jungleShellflower", (Object)"flowersJungle").build();
        int seedamount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        int juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple");
        for (String reedLike : reedLikePlant) {
            Block reedBlock = GameRegistry.findBlock((String)PlantMP, (String)reedLike);
            ItemStack reedStack = GameRegistry.findItemStack((String)PlantMP, (String)reedLike, (int)1);
            if (reedBlock == null || reedStack == null) continue;
            RecipeUtil.addFermenterRecipes(reedStack, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
            Farmables.farmables.get("farmPoales").add(new FarmableStacked(reedBlock, 14, 4));
        }
        for (String landCrop : landCropPlant) {
            Block landCropBlock = GameRegistry.findBlock((String)PlantMP, (String)("crop" + landCrop));
            ItemStack seedStack = GameRegistry.findItemStack((String)PlantMP, (String)("seed" + landCrop), (int)1);
            foodStack = GameRegistry.findItemStack((String)PlantMP, (String)("food" + landCrop), (int)1);
            if (landCropBlock == null) continue;
            if (foodStack != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{foodStack}, Fluids.JUICE.getFluid(juiceAmount));
            }
            if (seedStack != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{seedStack}, Fluids.SEEDOIL.getFluid(seedamount));
            }
            Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(seedStack, landCropBlock, 4, new ItemStack[0]));
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(landCropBlock, 4));
        }
        for (Map.Entry flower : nonGrowingFlowers.entrySet()) {
            Block flowerPlantBlock = GameRegistry.findBlock((String)PlantMP, (String)((String)flower.getKey()));
            if (flowerPlantBlock == null) continue;
            for (int i = 0; i < (Integer)flower.getValue(); ++i) {
                FlowerManager.flowerRegistry.registerPlantableFlower(flowerPlantBlock, i, 0.75, "flowersVanilla");
            }
        }
        for (Object wPlant : floatingWaterPlant.entrySet()) {
            Block waterPlantBlock = GameRegistry.findBlock((String)PlantMP, (String)((String)wPlant.getKey()));
            if (waterPlantBlock == null) continue;
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(waterPlantBlock, (Integer)wPlant.getValue()));
        }
        juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 25;
        juiceAmount = Math.max(juiceAmount, 1);
        for (Map.Entry berryBushCrop : berryBushPlant.entrySet()) {
            Block berryBushCropBlock = GameRegistry.findBlock((String)PlantMP, (String)("berrybush" + (String)berryBushCrop.getKey()));
            ItemStack berryBushStack = GameRegistry.findItemStack((String)PlantMP, (String)("berrybush" + (String)berryBushCrop.getKey()), (int)1);
            foodStack = GameRegistry.findItemStack((String)PlantMP, (String)("berries" + (String)berryBushCrop.getKey()), (int)1);
            if (berryBushCropBlock == null) continue;
            if (foodStack != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{foodStack}, Fluids.JUICE.getFluid(juiceAmount));
            }
            Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(berryBushStack, berryBushCropBlock, (Integer)berryBushCrop.getValue(), new ItemStack[0]));
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(berryBushCropBlock, (Integer)berryBushCrop.getValue()));
        }
        PluginPlantMegaPack.addMetaFlower((ImmutableMap<String, Integer>)desertPlant, "flowersCacti", false);
        PluginPlantMegaPack.addMetaFlower((ImmutableMap<String, Integer>)junglePlant, "flowersJungle", true);
        PluginPlantMegaPack.addMetaFlower((ImmutableMap<String, Integer>)vanillaPlant, "flowersVanilla", true);
        PluginPlantMegaPack.addMetaFlower((ImmutableMap<String, Integer>)fungusPlant, "flowersMushrooms", true);
        for (Map.Entry special : specialCaseTwoTall.entrySet()) {
            Block plantBlock = GameRegistry.findBlock((String)PlantMP, (String)((String)special.getKey()));
            ItemStack specialStack = GameRegistry.findItemStack((String)PlantMP, (String)((String)special.getKey()), (int)1);
            if (plantBlock == null || plantBlock == null) continue;
            FlowerManager.flowerRegistry.registerAcceptableFlower(plantBlock, (String)special.getValue());
            FlowerManager.flowerRegistry.registerPlantableFlower(plantBlock, 0, 0.75, (String)special.getValue());
            Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(specialStack, plantBlock, 4, new ItemStack[0]));
        }
        for (Object wPlant : waterPlant) {
            ItemStack waterPlantStack = GameRegistry.findItemStack((String)PlantMP, (String)wPlant, (int)1);
            if (waterPlantStack == null) continue;
            RecipeUtil.addFermenterRecipes(waterPlantStack, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        }
    }

    private static void addMetaFlower(ImmutableMap<String, Integer> flowerMap, String flowertype, boolean plantable) {
        for (Map.Entry flower : flowerMap.entrySet()) {
            Block flowerBlock = GameRegistry.findBlock((String)PlantMP, (String)((String)flower.getKey()));
            ItemStack flowerStack = GameRegistry.findItemStack((String)PlantMP, (String)((String)flower.getKey()), (int)1);
            FlowerManager.flowerRegistry.registerAcceptableFlower(flowerBlock, flowertype);
            if (plantable && flowerBlock != null) {
                FlowerManager.flowerRegistry.registerPlantableFlower(flowerBlock, 0, 0.75, flowertype);
            }
            if (flowerStack == null || flowerBlock == null) continue;
            Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(flowerStack, flowerBlock, (Integer)flower.getValue(), new ItemStack[0]));
            if ((Integer)flower.getValue() >= 5) continue;
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(flowerBlock, (Integer)flower.getValue()));
        }
    }
}

