/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import cpw.mods.fml.common.eventhandler.Event;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.inventory.InventoryGhostCrafting;
import forestry.factory.inventory.InventoryWorktable;
import forestry.factory.inventory.InventoryWorktableCrafting;
import forestry.factory.recipes.MemorizedRecipe;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.ICrafterWorktable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class TileWorktable
extends TileBase
implements ICrafterWorktable {
    private final RecipeMemory recipeMemory;
    private final InventoryAdapterTile craftingDisplay;
    private MemorizedRecipe currentRecipe;

    public TileWorktable() {
        super(GuiId.WorktableGUI, "worktable");
        this.setInternalInventory(new InventoryWorktable(this));
        this.craftingDisplay = new InventoryGhostCrafting<TileWorktable>(this, 10);
        this.recipeMemory = new RecipeMemory();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.craftingDisplay.writeToNBT(nbttagcompound);
        this.recipeMemory.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.craftingDisplay.readFromNBT(nbttagcompound);
        this.recipeMemory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.craftingDisplay.writeData(data);
        this.recipeMemory.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.craftingDisplay.readData(data);
        this.recipeMemory.readData(data);
    }

    @Override
    public void validate() {
        super.validate();
        this.recipeMemory.validate(this.worldObj);
    }

    public RecipeMemory getMemory() {
        return this.recipeMemory;
    }

    public void clearCraftMatrix() {
        for (int slot = 0; slot < this.craftingDisplay.getSizeInventory(); ++slot) {
            this.craftingDisplay.setInventorySlotContents(slot, null);
        }
    }

    public void chooseRecipe(int recipeIndex) {
        IInventory craftMatrix = this.recipeMemory.getRecipeCraftMatrix(recipeIndex);
        if (craftMatrix == null) {
            return;
        }
        for (int slot = 0; slot < craftMatrix.getSizeInventory(); ++slot) {
            this.craftingDisplay.setInventorySlotContents(slot, craftMatrix.getStackInSlot(slot));
        }
    }

    public void setRecipe(InventoryWorktableCrafting crafting) {
        ItemStack recipeOutput = CraftingManager.getInstance().findMatchingRecipe((InventoryCrafting)crafting, this.worldObj);
        this.currentRecipe = recipeOutput == null ? null : new MemorizedRecipe(crafting, recipeOutput);
        this.updateCraftResult();
    }

    private void updateCraftResult() {
        ItemStack result;
        if (this.currentRecipe != null && (result = this.currentRecipe.getRecipeOutput()) != null) {
            this.craftingDisplay.setInventorySlotContents(9, result.copy());
            return;
        }
        this.craftingDisplay.setInventorySlotContents(9, null);
    }

    private boolean canCraftCurrentRecipe() {
        if (this.currentRecipe == null) {
            return false;
        }
        ItemStack[] recipeItems = InventoryUtil.getStacks((IInventory)this.craftingDisplay, 0, 9);
        ItemStack[] inventory = InventoryUtil.getStacks((IInventory)this);
        ItemStack recipeOutput = this.currentRecipe.getRecipeOutput();
        return RecipeUtil.canCraftRecipe(this.worldObj, recipeItems, recipeOutput, inventory);
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        if (slotIndex == 9) {
            return this.canCraftCurrentRecipe();
        }
        return true;
    }

    @Override
    public boolean onCraftingStart(EntityPlayer player) {
        InventoryMapper inventory = new InventoryMapper((IInventory)this, 0, 18);
        ItemStack[] set = InventoryUtil.getStacks((IInventory)this.currentRecipe.getCraftMatrix());
        ItemStack[] removed = InventoryUtil.removeSets(inventory, 1, set, player, false, true, true);
        if (removed == null) {
            return false;
        }
        for (int i = 0; i < removed.length; ++i) {
            this.craftingDisplay.setInventorySlotContents(i, removed[i]);
        }
        return true;
    }

    @Override
    public void onCraftingComplete(EntityPlayer player) {
        IInventory craftingInventory = this.getCraftingDisplay();
        for (int i = 0; i < craftingInventory.getSizeInventory(); ++i) {
            ItemStack itemStack = craftingInventory.getStackInSlot(i);
            if (itemStack == null) continue;
            ItemStack container = null;
            if (itemStack.getItem().hasContainerItem(itemStack)) {
                container = itemStack.getItem().getContainerItem(itemStack);
            } else if (itemStack.stackSize > 1) {
                container = ItemStackUtil.createSplitStack(itemStack, itemStack.stackSize - 1);
                itemStack.stackSize = 1;
            }
            if (container == null) continue;
            if (container != null && container.isItemStackDamageable() && container.getItemDamage() > container.getMaxDamage()) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, container));
                continue;
            }
            if (InventoryUtil.tryAddStack((IInventory)this, container, true)) continue;
            player.dropPlayerItemWithRandomChoice(container, false);
        }
        if (!this.worldObj.isRemote) {
            this.recipeMemory.memorizeRecipe(this.worldObj.getTotalWorldTime(), this.currentRecipe);
        }
        this.updateCraftResult();
    }

    @Override
    public ItemStack getResult() {
        if (this.currentRecipe == null) {
            return null;
        }
        ItemStack result = this.currentRecipe.getRecipeOutput();
        if (result != null) {
            result = result.copy();
        }
        return result;
    }

    public IInventory getCraftingDisplay() {
        return new InventoryMapper((IInventory)this.craftingDisplay, 0, 9);
    }
}

