/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.core.INBTTagable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.utils.InventoryUtil;
import forestry.factory.inventory.InventoryWorktableCrafting;
import java.io.IOException;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public final class MemorizedRecipe
implements INBTTagable,
IStreamable {
    private final InventoryWorktableCrafting craftMatrix = new InventoryWorktableCrafting();
    private ItemStack recipeOutput;
    private long lastUsed;
    private boolean locked;

    public MemorizedRecipe() {
    }

    public MemorizedRecipe(InventoryWorktableCrafting craftMatrix, ItemStack recipeOutput) {
        InventoryUtil.deepCopyInventoryContents((IInventory)craftMatrix, (IInventory)this.craftMatrix);
        this.recipeOutput = recipeOutput;
    }

    public InventoryWorktableCrafting getCraftMatrix() {
        return this.craftMatrix;
    }

    public void updateRecipeOutputLegacy(World world) {
        if (this.recipeOutput == null) {
            this.recipeOutput = CraftingManager.getInstance().findMatchingRecipe((InventoryCrafting)this.craftMatrix, world);
        }
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public void updateLastUse(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void toggleLock() {
        this.locked = !this.locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public final void readFromNBT(NBTTagCompound nbttagcompound) {
        InventoryUtil.readFromNBT((IInventory)this.craftMatrix, nbttagcompound);
        this.lastUsed = nbttagcompound.getLong("LastUsed");
        this.locked = nbttagcompound.getBoolean("Locked");
        if (nbttagcompound.hasKey("Output")) {
            NBTTagCompound recipeOutputNbt = nbttagcompound.getCompoundTag("Output");
            this.recipeOutput = ItemStack.loadItemStackFromNBT((NBTTagCompound)recipeOutputNbt);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        InventoryUtil.writeToNBT((IInventory)this.craftMatrix, nbttagcompound);
        nbttagcompound.setLong("LastUsed", this.lastUsed);
        nbttagcompound.setBoolean("Locked", this.locked);
        NBTTagCompound recipeOutputNbt = new NBTTagCompound();
        this.recipeOutput.writeToNBT(recipeOutputNbt);
        nbttagcompound.setTag("Output", (NBTBase)recipeOutputNbt);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeInventory((IInventory)this.craftMatrix);
        data.writeItemStack(this.recipeOutput);
        data.writeLong(this.lastUsed);
        data.writeBoolean(this.locked);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        data.readInventory((IInventory)this.craftMatrix);
        this.recipeOutput = data.readItemStack();
        this.lastUsed = data.readLong();
        this.locked = data.readBoolean();
    }
}

