/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.ContainerTile;
import forestry.core.gui.IContainerCrafting;
import forestry.core.gui.IGuiSelectable;
import forestry.core.gui.slots.SlotCraftMatrix;
import forestry.core.gui.slots.SlotCrafter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.inventory.InventoryWorktableCrafting;
import forestry.factory.network.PacketWorktableMemoryUpdate;
import forestry.factory.tiles.TileWorktable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerWorktable
extends ContainerTile<TileWorktable>
implements IContainerCrafting,
IGuiSelectable {
    private final InventoryWorktableCrafting craftMatrix = new InventoryWorktableCrafting(this);
    private long lastUpdate;

    public ContainerWorktable(EntityPlayer player, TileWorktable tile) {
        super(tile, player.inventory, 8, 136);
        IInventory craftingDisplay = tile.getCraftingDisplay();
        IInventoryAdapter internalInventory = tile.getInternalInventory();
        for (int i = 0; i < 2; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlotToContainer(new Slot((IInventory)internalInventory, 0 + k + i * 9, 8 + k * 18, 90 + i * 18));
            }
        }
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 3; ++k1) {
                this.addSlotToContainer(new SlotCraftMatrix(this, craftingDisplay, k1 + l * 3, 11 + k1 * 18, 20 + l * 18));
            }
        }
        this.addSlotToContainer((Slot)new SlotCrafter(player, craftingDisplay, tile, 9, 77, 38));
        this.updateCraftMatrix();
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.lastUpdate == ((TileWorktable)this.tile).getMemory().getLastUpdate()) {
            return;
        }
        this.lastUpdate = ((TileWorktable)this.tile).getMemory().getLastUpdate();
        PacketWorktableMemoryUpdate packet = new PacketWorktableMemoryUpdate((TileWorktable)this.tile);
        this.sendPacketToCrafters(packet);
    }

    public void onCraftMatrixChanged(IInventory iinventory) {
        this.updateRecipe();
    }

    @Override
    public void onCraftMatrixChanged(IInventory iinventory, int slot) {
        ItemStack currentStack;
        if (slot >= this.craftMatrix.getSizeInventory()) {
            return;
        }
        ItemStack stack = iinventory.getStackInSlot(slot);
        if (!ItemStackUtil.isIdenticalItem(stack, currentStack = this.craftMatrix.getStackInSlot(slot))) {
            this.craftMatrix.setInventorySlotContents(slot, stack);
        }
    }

    private void updateCraftMatrix() {
        for (int i = 0; i < this.craftMatrix.getSizeInventory(); ++i) {
            this.craftMatrix.setInventorySlotContents(i, ((TileWorktable)this.tile).getCraftingDisplay().getStackInSlot(i));
        }
    }

    private void updateRecipe() {
        ((TileWorktable)this.tile).setRecipe(this.craftMatrix);
    }

    public static void clearRecipe() {
        ContainerWorktable.sendRecipeClick(-1, -1);
    }

    public static void sendRecipeClick(int mouseButton, int recipeIndex) {
        Proxies.net.sendToServer(new PacketGuiSelectRequest(mouseButton, recipeIndex));
    }

    @Override
    public void handleSelectionRequest(EntityPlayerMP player, PacketGuiSelectRequest packet) {
        int mouseButton = packet.getPrimaryIndex();
        int secondary = packet.getSecondaryIndex();
        if (mouseButton < 0) {
            ((TileWorktable)this.tile).clearCraftMatrix();
        } else if (mouseButton == 0) {
            ((TileWorktable)this.tile).chooseRecipe(secondary);
            this.updateCraftMatrix();
            this.updateRecipe();
        } else {
            ((TileWorktable)this.tile).getMemory().toggleLock(player.worldObj.getTotalWorldTime(), secondary);
        }
    }
}

