/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.proxy.Proxies;
import forestry.core.render.EnumTankLevel;
import forestry.core.render.ForestryResource;
import forestry.core.render.IBlockRenderer;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IRenderableTile;
import java.awt.Color;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderMachine
extends TileEntitySpecialRenderer
implements IBlockRenderer {
    private final ModelRenderer basefront;
    private final ModelRenderer baseback;
    private final ModelRenderer resourceTank;
    private final ModelRenderer productTank;
    private ResourceLocation textureBase;
    private ResourceLocation textureResourceTank;
    private ResourceLocation textureProductTank;
    private final EnumMap<EnumTankLevel, ResourceLocation> texturesTankLevels = new EnumMap(EnumTankLevel.class);

    private RenderMachine() {
        RenderModelBase model = new RenderModelBase();
        this.basefront = new ModelRenderer((ModelBase)model, 0, 0);
        this.basefront.addBox(-8.0f, -8.0f, -8.0f, 16, 4, 16);
        this.basefront.rotationPointX = 8.0f;
        this.basefront.rotationPointY = 8.0f;
        this.basefront.rotationPointZ = 8.0f;
        this.baseback = new ModelRenderer((ModelBase)model, 0, 0);
        this.baseback.addBox(-8.0f, 4.0f, -8.0f, 16, 4, 16);
        this.baseback.rotationPointX = 8.0f;
        this.baseback.rotationPointY = 8.0f;
        this.baseback.rotationPointZ = 8.0f;
        this.resourceTank = new ModelRenderer((ModelBase)model, 0, 0);
        this.resourceTank.addBox(-6.0f, -8.0f, -6.0f, 12, 16, 6);
        this.resourceTank.rotationPointX = 8.0f;
        this.resourceTank.rotationPointY = 8.0f;
        this.resourceTank.rotationPointZ = 8.0f;
        this.productTank = new ModelRenderer((ModelBase)model, 0, 0);
        this.productTank.addBox(-6.0f, -8.0f, 0.0f, 12, 16, 6);
        this.productTank.rotationPointX = 8.0f;
        this.productTank.rotationPointY = 8.0f;
        this.productTank.rotationPointZ = 8.0f;
    }

    public RenderMachine(String baseTexture) {
        this();
        this.textureBase = new ForestryResource(baseTexture + "base.png");
        this.textureProductTank = new ForestryResource(baseTexture + "tank_product_empty.png");
        this.textureResourceTank = new ForestryResource(baseTexture + "tank_resource_empty.png");
        for (EnumTankLevel tankLevel : EnumTankLevel.values()) {
            if (tankLevel == EnumTankLevel.EMPTY) continue;
            String tankLevelString = tankLevel.toString().toLowerCase(Locale.ENGLISH);
            this.texturesTankLevels.put(tankLevel, new ForestryResource("textures/blocks/machine_tank_" + tankLevelString + ".png"));
        }
    }

    @Override
    public void inventoryRender(double x, double y, double z) {
        this.render(TankRenderInfo.EMPTY, TankRenderInfo.EMPTY, ForgeDirection.SOUTH, x, y, z);
    }

    public void renderTileEntityAt(TileEntity tileentity, double d, double d1, double d2, float f) {
        IRenderableTile generator = (IRenderableTile)tileentity;
        this.render(generator.getResourceTankInfo(), generator.getProductTankInfo(), generator.getOrientation(), d, d1, d2);
    }

    private void render(TankRenderInfo resourceTankInfo, TankRenderInfo productTankInfo, ForgeDirection orientation, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        if (orientation == null) {
            orientation = ForgeDirection.WEST;
        }
        switch (orientation) {
            case EAST: {
                angle[1] = (float)Math.PI;
                angle[2] = -1.5707964f;
                break;
            }
            case WEST: {
                angle[2] = 1.5707964f;
                break;
            }
            case UP: {
                break;
            }
            case DOWN: {
                angle[2] = (float)Math.PI;
                break;
            }
            case SOUTH: {
                angle[0] = 1.5707964f;
                angle[2] = 1.5707964f;
                break;
            }
            default: {
                angle[0] = -1.5707964f;
                angle[2] = 1.5707964f;
            }
        }
        this.basefront.rotateAngleX = angle[0];
        this.basefront.rotateAngleY = angle[1];
        this.basefront.rotateAngleZ = angle[2];
        this.baseback.rotateAngleX = angle[0];
        this.baseback.rotateAngleY = angle[1];
        this.baseback.rotateAngleZ = angle[2];
        this.resourceTank.rotateAngleX = angle[0];
        this.resourceTank.rotateAngleY = angle[1];
        this.resourceTank.rotateAngleZ = angle[2];
        this.productTank.rotateAngleX = angle[0];
        this.productTank.rotateAngleY = angle[1];
        this.productTank.rotateAngleZ = angle[2];
        float factor = 0.0625f;
        Proxies.render.bindTexture(this.textureBase);
        this.basefront.render(factor);
        this.baseback.render(factor);
        this.renderTank(this.resourceTank, this.textureResourceTank, resourceTankInfo, factor);
        this.renderTank(this.productTank, this.textureProductTank, productTankInfo, factor);
        GL11.glPopMatrix();
    }

    private void renderTank(ModelRenderer tankModel, ResourceLocation textureBase, TankRenderInfo renderInfo, float factor) {
        Proxies.render.bindTexture(textureBase);
        tankModel.render(factor);
        ResourceLocation textureResourceTankLevel = this.texturesTankLevels.get((Object)renderInfo.getLevel());
        if (textureResourceTankLevel == null) {
            return;
        }
        Color primaryTankColor = renderInfo.getFluidColor();
        float[] colors = new float[3];
        primaryTankColor.getRGBColorComponents(colors);
        GL11.glColor4f((float)colors[0], (float)colors[1], (float)colors[2], (float)1.0f);
        Proxies.render.bindTexture(textureResourceTankLevel);
        tankModel.render(factor);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static class RenderModelBase
    extends ModelBase {
        private RenderModelBase() {
        }
    }
}

