/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.mail.ILetter;
import forestry.core.config.ForestryItem;
import forestry.core.render.TextureManager;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class LetterProperties {
    @SideOnly(value=Side.CLIENT)
    private static IIcon[][] icons;

    public static ItemStack createStampedLetterStack(ILetter letter) {
        Size size = LetterProperties.getSize(letter);
        int meta = LetterProperties.encodeMeta(State.STAMPED, size);
        return ForestryItem.letters.getItemStack(1, meta);
    }

    public static void closeLetter(ItemStack parent, ILetter letter) {
        State state = LetterProperties.getState(parent.getItemDamage());
        Size size = LetterProperties.getSize(parent.getItemDamage());
        switch (state) {
            case OPENED: {
                if (letter.countAttachments() > 0) break;
                state = State.EMPTIED;
                break;
            }
            case FRESH: 
            case STAMPED: {
                state = letter.isMailable() && letter.isPostPaid() ? State.STAMPED : State.FRESH;
                size = LetterProperties.getSize(letter);
                break;
            }
        }
        int meta = LetterProperties.encodeMeta(state, size);
        parent.setItemDamage(meta);
        letter.writeToNBT(parent.getTagCompound());
    }

    public static void openLetter(ItemStack parent) {
        int oldMeta = parent.getItemDamage();
        State state = LetterProperties.getState(oldMeta);
        if (state == State.FRESH || state == State.STAMPED) {
            Size size = LetterProperties.getSize(oldMeta);
            int newMeta = LetterProperties.encodeMeta(State.OPENED, size);
            parent.setItemDamage(newMeta);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister register) {
        icons = new IIcon[3][4];
        for (int i = 0; i < 3; ++i) {
            LetterProperties.icons[i][0] = TextureManager.registerTex(register, "mail/letter." + i + ".fresh");
            LetterProperties.icons[i][1] = TextureManager.registerTex(register, "mail/letter." + i + ".stamped");
            LetterProperties.icons[i][2] = TextureManager.registerTex(register, "mail/letter." + i + ".opened");
            LetterProperties.icons[i][3] = TextureManager.registerTex(register, "mail/letter." + i + ".emptied");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getIconFromDamage(int damage) {
        State state = LetterProperties.getState(damage);
        Size size = LetterProperties.getSize(damage);
        return icons[size.ordinal()][state.ordinal()];
    }

    private static State getState(int meta) {
        int ordinal = meta & 0xF;
        State[] values = State.values();
        if (ordinal >= values.length) {
            ordinal = 0;
        }
        return values[ordinal];
    }

    private static Size getSize(int meta) {
        int ordinal = meta >> 4;
        Size[] values = Size.values();
        if (ordinal >= values.length) {
            ordinal = 0;
        }
        return values[ordinal];
    }

    private static int encodeMeta(State state, Size size) {
        int meta = size.ordinal() << 4;
        return meta |= state.ordinal();
    }

    private static Size getSize(ILetter letter) {
        int count = letter.countAttachments();
        if (count > 5) {
            return Size.BIG;
        }
        if (count > 1) {
            return Size.SMALL;
        }
        return Size.EMPTY;
    }

    private static enum Size {
        EMPTY,
        SMALL,
        BIG;

    }

    private static enum State {
        FRESH,
        STAMPED,
        OPENED,
        EMPTIED;

    }
}

