/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.render.TextureManager;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public enum EnumFarmBlockTexture {
    BRICK_STONE(new ItemStack(Blocks.stonebrick, 1, 0)),
    BRICK_MOSSY(new ItemStack(Blocks.stonebrick, 1, 1)),
    BRICK_CRACKED(new ItemStack(Blocks.stonebrick, 1, 2)),
    BRICK(new ItemStack(Blocks.brick_block)),
    SANDSTONE_SMOOTH(new ItemStack(Blocks.sandstone, 1, 2)),
    SANDSTONE_CHISELED(new ItemStack(Blocks.sandstone, 1, 1)),
    BRICK_NETHER(new ItemStack(Blocks.nether_brick)),
    BRICK_CHISELED(new ItemStack(Blocks.stonebrick, 1, 3)),
    QUARTZ(new ItemStack(Blocks.quartz_block, 1, 0)),
    QUARTZ_CHISELED(new ItemStack(Blocks.quartz_block, 1, 1)),
    QUARTZ_LINES(new ItemStack(Blocks.quartz_block, 1, 2));

    @SideOnly(value=Side.CLIENT)
    private static List<IIcon> icons;
    private final ItemStack base;

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister register) {
        icons = Arrays.asList(TextureManager.registerTex(register, "farm/plain"), TextureManager.registerTex(register, "farm/reverse"), TextureManager.registerTex(register, "farm/top"), TextureManager.registerTex(register, "farm/band"), TextureManager.registerTex(register, "farm/gears"), TextureManager.registerTex(register, "farm/hatch"), TextureManager.registerTex(register, "farm/valve"), TextureManager.registerTex(register, "farm/control"));
    }

    private EnumFarmBlockTexture(ItemStack base) {
        this.base = base;
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getIcon(int type) {
        return icons.get(type);
    }

    public void saveToCompound(NBTTagCompound compound) {
        compound.setInteger("FarmBlock", this.ordinal());
    }

    public String getName() {
        return this.base.getItem().getItemStackDisplayName(this.base);
    }

    public ItemStack getBase() {
        return this.base;
    }

    public static EnumFarmBlockTexture getFromCompound(NBTTagCompound compound) {
        int farmBlockOrdinal;
        if (compound != null && (farmBlockOrdinal = compound.getInteger("FarmBlock")) < EnumFarmBlockTexture.values().length) {
            return EnumFarmBlockTexture.values()[farmBlockOrdinal];
        }
        return BRICK_STONE;
    }
}

