/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.gui;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmLogic;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.ledgers.ClimateLedger;
import forestry.core.gui.ledgers.OwnerLedger;
import forestry.core.gui.tooltips.ToolTip;
import forestry.core.gui.widgets.SocketWidget;
import forestry.core.gui.widgets.TankWidget;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import forestry.farming.gui.ContainerFarm;
import forestry.farming.gui.FarmLedger;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.MultiblockLogicFarm;
import forestry.farming.tiles.TileFarm;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class GuiFarm
extends GuiForestry<ContainerFarm, TileFarm> {
    public GuiFarm(EntityPlayer player, TileFarm tile) {
        super("textures/gui/mfarm.png", new ContainerFarm(player.inventory, tile), tile);
        this.widgetManager.add(new TankWidget(this.widgetManager, 15, 19, 0).setOverlayOrigin(216, 18));
        this.widgetManager.add(new SocketWidget(this.widgetManager, 69, 40, tile, 0));
        this.widgetManager.add(new FarmLogicSlot(this.widgetManager, 69, 22, FarmDirection.NORTH));
        this.widgetManager.add(new FarmLogicSlot(this.widgetManager, 69, 58, FarmDirection.SOUTH));
        this.widgetManager.add(new FarmLogicSlot(this.widgetManager, 51, 40, FarmDirection.WEST));
        this.widgetManager.add(new FarmLogicSlot(this.widgetManager, 87, 40, FarmDirection.EAST));
        this.xSize = 216;
        this.ySize = 220;
    }

    @Override
    public void initGui() {
        super.initGui();
        IFarmControllerInternal farmController = ((MultiblockLogicFarm)((TileFarm)this.inventory).getMultiblockLogic()).getController();
        this.ledgerManager.add(new ClimateLedger(this.ledgerManager, farmController));
        this.ledgerManager.add(new FarmLedger(this.ledgerManager, farmController.getFarmLedgerDelegate()));
        this.ledgerManager.add(new OwnerLedger(this.ledgerManager, farmController));
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY);
        String title = StringUtil.localize("gui.farm.title");
        this.fontRendererObj.drawString(title, this.getCenteredOffset(title), 6, this.fontColor.get("gui.title"));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        int fertilizerRemain = ((MultiblockLogicFarm)((TileFarm)this.inventory).getMultiblockLogic()).getController().getStoredFertilizerScaled(16);
        if (fertilizerRemain > 0) {
            this.drawTexturedModalRect(this.guiLeft + 81, this.guiTop + 94 + 17 - fertilizerRemain, this.xSize, 17 - fertilizerRemain, 4, fertilizerRemain);
        }
    }

    private class FarmLogicSlot
    extends Widget {
        private final FarmDirection farmDirection;
        protected final ToolTip toolTip;

        public FarmLogicSlot(WidgetManager manager, int xPos, int yPos, FarmDirection farmDirection) {
            super(manager, xPos, yPos);
            this.toolTip = new ToolTip(250){

                @Override
                public void refresh() {
                    FarmLogicSlot.this.toolTip.clear();
                    if (FarmLogicSlot.this.getLogic() == null) {
                        return;
                    }
                    FarmLogicSlot.this.toolTip.add(FarmLogicSlot.this.getLogic().getName());
                    FarmLogicSlot.this.toolTip.add("Fertilizer: " + FarmLogicSlot.this.getLogic().getFertilizerConsumption());
                    FarmLogicSlot.this.toolTip.add("Water: " + FarmLogicSlot.this.getLogic().getWaterConsumption(((MultiblockLogicFarm)((TileFarm)GuiFarm.this.inventory).getMultiblockLogic()).getController().getFarmLedgerDelegate().getHydrationModifier()));
                }
            };
            this.farmDirection = farmDirection;
        }

        private IFarmLogic getLogic() {
            return ((MultiblockLogicFarm)((TileFarm)GuiFarm.this.inventory).getMultiblockLogic()).getController().getFarmLogic(this.farmDirection);
        }

        private IIcon getIconIndex() {
            if (this.getLogic() == null) {
                return null;
            }
            return this.getLogic().getIcon();
        }

        @Override
        public void draw(int startX, int startY) {
            if (this.getLogic() == null) {
                return;
            }
            if (this.getIconIndex() != null) {
                GL11.glDisable((int)2896);
                Proxies.render.bindTexture(this.getLogic().getSpriteSheet());
                this.manager.gui.drawTexturedModelRectFromIcon(startX + this.xPos, startY + this.yPos, this.getIconIndex(), 16, 16);
                GL11.glEnable((int)2896);
            }
        }

        @Override
        public ToolTip getToolTip() {
            return this.toolTip;
        }
    }
}

