/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerProvider;
import cpw.mods.fml.common.Optional;
import forestry.api.core.ForestryAPI;
import forestry.api.multiblock.IMultiblockController;
import forestry.apiculture.multiblock.MultiblockLogicAlveary;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.apiculture.trigger.ApicultureTriggers;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.network.IStreamableGui;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.ITitled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="buildcraft.api.statements.ITriggerProvider", modid="BuildCraftAPI|statements")
public class TileAlvearyPlain
extends TileAlveary
implements IClimatised,
IHintSource,
ITitled,
ITriggerProvider,
IStreamableGui {
    @Override
    public void onMachineAssembled(IMultiblockController multiblockController, ChunkCoordinates minCoord, ChunkCoordinates maxCoord) {
        super.onMachineAssembled(multiblockController, minCoord, maxCoord);
        if (!this.worldObj.isRemote && this.yCoord == maxCoord.posY && (this.xCoord > minCoord.posX && this.xCoord < maxCoord.posX || this.zCoord > minCoord.posZ && this.zCoord < maxCoord.posZ)) {
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, 1, 2);
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (!this.worldObj.isRemote) {
            this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, 0, 2);
        }
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getInternalInventory();
    }

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    @Override
    public void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, GuiId.AlvearyGUI.ordinal(), this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().writeGuiData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().readGuiData(data);
    }

    @Override
    public String getUnlocalizedTitle() {
        return "tile.for.alveary.0.name";
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"apiary");
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerInternal> getInternalTriggers(IStatementContainer container) {
        return null;
    }

    @Optional.Method(modid="BuildCraftAPI|statements")
    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection side, TileEntity tile) {
        ArrayList<ITriggerExternal> res = new ArrayList<ITriggerExternal>();
        res.add(ApicultureTriggers.missingQueen);
        res.add(ApicultureTriggers.missingDrone);
        return res;
    }

    @Override
    public float getExactTemperature() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getExactTemperature();
    }

    @Override
    public float getExactHumidity() {
        return ((MultiblockLogicAlveary)this.getMultiblockLogic()).getController().getExactHumidity();
    }
}

