/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.entities;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.apiculture.gui.IGuiBeeHousingInventory;
import forestry.apiculture.network.PacketBeeLogicEntityRequest;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.core.entities.EntityMinecartContainerForestry;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamableGui;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IClimatised;
import java.io.IOException;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class EntityMinecartBeeHousingBase
extends EntityMinecartContainerForestry
implements IBeeHousing,
IGuiBeeHousingInventory,
IClimatised,
IStreamableGui {
    private static final Random random = new Random();
    private static final int beeFXInterval = 4;
    private static final int pollenFXInterval = 50;
    private final int beeFXTime = random.nextInt(4);
    private final int pollenFXTime = random.nextInt(50);
    private final IBeekeepingLogic beeLogic = BeeManager.beeRoot.createBeekeepingLogic(this);
    private final IErrorLogic errorLogic = ForestryAPI.errorStateRegistry.createErrorLogic();
    private int breedingProgressPercent = 0;
    private boolean needsActiveUpdate = true;

    public EntityMinecartBeeHousingBase(World world) {
        super(world);
    }

    public EntityMinecartBeeHousingBase(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromBiome(this.getBiome(), (int)this.posX, (int)this.posY, (int)this.posZ);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getBiome().rainfall);
    }

    @Override
    public float getExactTemperature() {
        return this.getBiome().temperature;
    }

    @Override
    public float getExactHumidity() {
        return this.getBiome().rainfall;
    }

    @Override
    public int getBlockLightValue() {
        return this.worldObj.getBlockLightValue((int)this.posX, (int)this.posY + 1, (int)this.posZ);
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.worldObj.canBlockSeeTheSky((int)this.posX, (int)this.posY + 1, (int)this.posZ);
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.worldObj.getBiomeGenForCoords((int)this.posX, (int)this.posZ);
    }

    @Override
    public GameProfile getOwner() {
        return this.getAccessHandler().getOwner();
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    public ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates((int)this.posX, (int)this.posY, (int)this.posZ);
    }

    @Override
    public Vec3 getBeeFXCoordinates() {
        return Vec3.createVectorHelper((double)this.posX, (double)(this.posY + 0.25), (double)this.posZ);
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.beeLogic.getBeeProgressPercent());
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.breedingProgressPercent = data.readVarInt();
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote) {
            if (this.beeLogic.canWork()) {
                this.beeLogic.doWork();
            }
        } else {
            if (this.needsActiveUpdate) {
                PacketBeeLogicEntityRequest packet = new PacketBeeLogicEntityRequest((Entity)this);
                Proxies.net.sendToServer(packet);
                this.needsActiveUpdate = false;
            }
            if (this.beeLogic.canDoBeeFX()) {
                if (this.worldObj.getTotalWorldTime() % 4L == (long)this.beeFXTime) {
                    this.beeLogic.doBeeFX();
                }
                if (this.worldObj.getTotalWorldTime() % 50L == (long)this.pollenFXTime) {
                    TileBeeHousingBase.doPollenFX(this.worldObj, this.posX - 0.5, this.posY - 0.1, this.posZ - 0.5);
                }
            }
        }
    }

    @Override
    protected void readEntityFromNBT(NBTTagCompound nbtTagCompound) {
        super.readEntityFromNBT(nbtTagCompound);
        this.beeLogic.readFromNBT(nbtTagCompound);
    }

    @Override
    protected void writeEntityToNBT(NBTTagCompound nbtTagCompound) {
        super.writeEntityToNBT(nbtTagCompound);
        this.beeLogic.writeToNBT(nbtTagCompound);
    }
}

