/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorLogic;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmInventory;
import forestry.api.farming.IFarmListener;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmable;
import forestry.api.multiblock.IFarmComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.access.EnumAccess;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.RectangularMultiblockControllerBase;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.utils.Log;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.vect.Vect;
import forestry.core.utils.vect.VectUtil;
import forestry.farming.FarmHelper;
import forestry.farming.FarmTarget;
import forestry.farming.gui.IFarmLedgerDelegate;
import forestry.farming.logic.FarmLogicArboreal;
import forestry.farming.multiblock.FarmFertilizerManager;
import forestry.farming.multiblock.FarmHydrationManager;
import forestry.farming.multiblock.FarmMultiblockSizeLimits;
import forestry.farming.multiblock.IFarmControllerInternal;
import forestry.farming.multiblock.InventoryFarm;
import forestry.farming.tiles.TileFarmPlain;
import forestry.farming.tiles.TileGearbox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FarmController
extends RectangularMultiblockControllerBase
implements IFarmControllerInternal,
ILiquidTankTile {
    private final Map<FarmDirection, List<FarmTarget>> targets = new EnumMap<FarmDirection, List<FarmTarget>>(FarmDirection.class);
    private int allowedExtent = 0;
    private IFarmLogic harvestProvider;
    private final Stack<ICrop> pendingCrops = new Stack();
    private final Stack<ItemStack> pendingProduce = new Stack();
    private Stage stage = Stage.CULTIVATE;
    private final Map<IFarmComponent.Active, Integer> farmActiveComponents = new HashMap<IFarmComponent.Active, Integer>();
    private final Set<IFarmListener> farmListeners = new HashSet<IFarmListener>();
    private final Map<FarmDirection, IFarmLogic> farmLogics = new EnumMap<FarmDirection, IFarmLogic>(FarmDirection.class);
    private final InventoryAdapter sockets;
    private final InventoryFarm inventory;
    private final TankManager tankManager;
    private final StandardTank resourceTank = new FilteredTank(10000, FluidRegistry.WATER);
    private final FarmHydrationManager hydrationManager;
    private final FarmFertilizerManager fertilizerManager;
    private int noPowerTime = 0;
    private BiomeGenBase cachedBiome;
    private int[] coords;
    private int[] offset;
    private int[] area;

    private static FarmDirection getLayoutDirection(FarmDirection farmSide) {
        switch (farmSide) {
            case NORTH: {
                return FarmDirection.WEST;
            }
            case WEST: {
                return FarmDirection.SOUTH;
            }
            case SOUTH: {
                return FarmDirection.EAST;
            }
            case EAST: {
                return FarmDirection.NORTH;
            }
        }
        return null;
    }

    public FarmController(World world) {
        super(world, FarmMultiblockSizeLimits.instance);
        this.tankManager = new TankManager(this, this.resourceTank);
        this.inventory = new InventoryFarm(this);
        this.sockets = new InventoryAdapter(1, "sockets");
        this.hydrationManager = new FarmHydrationManager(this);
        this.fertilizerManager = new FarmFertilizerManager();
        this.refreshFarmLogics();
    }

    @Override
    public IFarmLedgerDelegate getFarmLedgerDelegate() {
        return this.hydrationManager;
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        if (this.isAssembled()) {
            return this.inventory;
        }
        return FakeInventoryAdapter.instance();
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    private BiomeGenBase getBiome() {
        if (this.cachedBiome == null) {
            ChunkCoordinates coords = this.getReferenceCoord();
            this.cachedBiome = this.worldObj.getBiomeGenForCoords(coords.posX, coords.posZ);
        }
        return this.cachedBiome;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockComponent part, NBTTagCompound data) {
        this.readFromNBT(data);
    }

    @Override
    protected void onBlockAdded(IMultiblockComponent newPart) {
        if (newPart instanceof IFarmComponent.Listener) {
            IFarmComponent.Listener listenerPart = (IFarmComponent.Listener)newPart;
            this.farmListeners.add(listenerPart.getFarmListener());
        }
        if (newPart instanceof IFarmComponent.Active) {
            this.farmActiveComponents.put((IFarmComponent.Active)newPart, this.worldObj.rand.nextInt(256));
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockComponent oldPart) {
        if (oldPart instanceof IFarmComponent.Listener) {
            IFarmComponent.Listener listenerPart = (IFarmComponent.Listener)oldPart;
            this.farmListeners.remove(listenerPart.getFarmListener());
        }
        if (oldPart instanceof IFarmComponent.Active) {
            this.farmActiveComponents.remove(oldPart);
        }
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        super.isMachineWhole();
        boolean hasGearbox = false;
        for (IMultiblockComponent part : this.connectedParts) {
            if (!(part instanceof TileGearbox)) continue;
            hasGearbox = true;
            break;
        }
        if (!hasGearbox) {
            throw new MultiblockValidationException(StatCollector.translateToLocal((String)"for.multiblock.farm.error.needGearbox"));
        }
    }

    @Override
    protected void onMachineDisassembled() {
        super.onMachineDisassembled();
        this.targets.clear();
    }

    @Override
    public void isGoodForExteriorLevel(IMultiblockComponent part, int level) throws MultiblockValidationException {
        if (level == 2 && !(part instanceof TileFarmPlain)) {
            throw new MultiblockValidationException(StatCollector.translateToLocal((String)"for.multiblock.farm.error.needPlainBand"));
        }
    }

    @Override
    public void isGoodForInterior(IMultiblockComponent part) throws MultiblockValidationException {
        if (!(part instanceof TileFarmPlain)) {
            throw new MultiblockValidationException(StatCollector.translateToLocal((String)"for.multiblock.farm.error.needPlainInterior"));
        }
    }

    @Override
    public void onAssimilate(IMultiblockControllerInternal assimilated) {
    }

    @Override
    public void onAssimilated(IMultiblockControllerInternal assimilator) {
    }

    @Override
    protected boolean updateServer(int tickCount) {
        this.hydrationManager.updateServer(this.worldObj, this.getBiome());
        if (this.updateOnInterval(20)) {
            this.inventory.drainCan(this.tankManager);
        }
        boolean hasPower = false;
        for (Map.Entry<IFarmComponent.Active, Integer> entry : this.farmActiveComponents.entrySet()) {
            IFarmComponent.Active farmComponent = entry.getKey();
            if (farmComponent instanceof TileGearbox) {
                hasPower |= ((TileGearbox)farmComponent).getEnergyManager().getTotalEnergyStored() > 0;
            }
            int tickOffset = entry.getValue();
            farmComponent.updateServer(tickCount + tickOffset);
        }
        if (hasPower) {
            this.noPowerTime = 0;
            this.getErrorLogic().setCondition(false, EnumErrorCode.NO_POWER);
        } else if (this.noPowerTime <= 4) {
            ++this.noPowerTime;
        } else {
            this.getErrorLogic().setCondition(true, EnumErrorCode.NO_POWER);
        }
        return true;
    }

    @Override
    protected void updateClient(int tickCount) {
        for (Map.Entry<IFarmComponent.Active, Integer> entry : this.farmActiveComponents.entrySet()) {
            IFarmComponent.Active farmComponent = entry.getKey();
            int tickOffset = entry.getValue();
            farmComponent.updateClient(tickCount + tickOffset);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.sockets.writeToNBT(data);
        this.hydrationManager.writeToNBT(data);
        this.tankManager.writeToNBT(data);
        this.fertilizerManager.writeToNBT(data);
        this.inventory.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.sockets.readFromNBT(data);
        this.hydrationManager.readFromNBT(data);
        this.tankManager.readFromNBT(data);
        this.fertilizerManager.readFromNBT(data);
        this.inventory.readFromNBT(data);
        this.refreshFarmLogics();
    }

    @Override
    public void formatDescriptionPacket(NBTTagCompound data) {
        this.sockets.writeToNBT(data);
        this.hydrationManager.writeToNBT(data);
        this.tankManager.writeToNBT(data);
        this.fertilizerManager.writeToNBT(data);
    }

    @Override
    public void decodeDescriptionPacket(NBTTagCompound data) {
        this.sockets.readFromNBT(data);
        this.hydrationManager.readFromNBT(data);
        this.tankManager.readFromNBT(data);
        this.fertilizerManager.readFromNBT(data);
        this.refreshFarmLogics();
    }

    @Override
    public ChunkCoordinates getCoordinates() {
        ChunkCoordinates coord = this.getReferenceCoord();
        return new ChunkCoordinates(coord);
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        if (oldAccess == EnumAccess.SHARED || newAccess == EnumAccess.SHARED) {
            for (IMultiblockComponent part : this.connectedParts) {
                if (!(part instanceof TileEntity)) continue;
                TileEntity tile = (TileEntity)part;
                tile.getWorldObj().notifyBlocksOfNeighborChange(tile.xCoord, tile.yCoord, tile.zCoord, tile.getBlockType());
            }
            this.markDirty();
        }
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        this.tankManager.writeData(data);
        this.hydrationManager.writeData(data);
        this.fertilizerManager.writeData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.tankManager.readData(data);
        this.hydrationManager.readData(data);
        this.fertilizerManager.readData(data);
    }

    private void refreshFarmLogics() {
        ICircuitBoard chipset;
        for (FarmDirection direction : FarmDirection.values()) {
            this.resetFarmLogic(direction);
        }
        ItemStack chip = this.sockets.getStackInSlot(0);
        if (chip != null && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(chip)) != null) {
            chipset.onLoad(this);
        }
    }

    @Override
    public EnumTemperature getTemperature() {
        ChunkCoordinates coords = this.getReferenceCoord();
        return EnumTemperature.getFromBiome(this.getBiome(), coords.posX, coords.posY, coords.posZ);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public float getExactTemperature() {
        ChunkCoordinates coords = this.getReferenceCoord();
        return this.getBiome().getFloatTemperature(coords.posX, coords.posY, coords.posZ);
    }

    @Override
    public float getExactHumidity() {
        return this.getBiome().rainfall;
    }

    @Override
    public int[] getCoords() {
        if (this.coords == null) {
            ChunkCoordinates centerCoord = this.getCenterCoord();
            this.coords = new int[]{centerCoord.posX, centerCoord.posY, centerCoord.posZ};
        }
        return this.coords;
    }

    @Override
    public int[] getOffset() {
        if (this.offset == null) {
            this.offset = new int[]{-this.getArea()[0] / 2, -2, -this.getArea()[2] / 2};
        }
        return this.offset;
    }

    @Override
    public int[] getArea() {
        if (this.area == null) {
            this.area = new int[]{7 + this.allowedExtent * 2, 13, 7 + this.allowedExtent * 2};
        }
        return this.area;
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    @Override
    public boolean doWork() {
        if (this.targets.isEmpty() || this.updateOnInterval(400)) {
            this.setUpFarmlandTargets();
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        if (!this.pendingProduce.isEmpty()) {
            boolean added = this.inventory.tryAddPendingProduce(this.pendingProduce);
            errorLogic.setCondition(!added, EnumErrorCode.NO_SPACE_INVENTORY);
            return added;
        }
        boolean hasFertilizer = this.fertilizerManager.maintainFertilizer(this.inventory);
        if (errorLogic.setCondition(!hasFertilizer, EnumErrorCode.NO_FERTILIZER)) {
            return false;
        }
        if (!this.pendingCrops.isEmpty()) {
            if (this.cullCrop(this.pendingCrops.peek(), this.harvestProvider)) {
                this.pendingCrops.pop();
                return true;
            }
            return false;
        }
        FarmWorkStatus farmWorkStatus = new FarmWorkStatus();
        for (FarmDirection farmSide : FarmDirection.values()) {
            IFarmLogic logic = this.getFarmLogic(farmSide);
            if (logic == null || FarmController.isCycleCanceledByListeners(logic, farmSide, this.farmListeners)) continue;
            if (this.collectWindfall(logic)) {
                farmWorkStatus.didWork = true;
            }
            List<FarmTarget> farmTargets = this.targets.get((Object)farmSide);
            if (this.stage == Stage.HARVEST) {
                Collection<ICrop> harvested = FarmController.harvestTargets(farmTargets, logic, this.farmListeners);
                boolean bl = farmWorkStatus.didWork = harvested.size() > 0;
                if (harvested.size() > 0) {
                    this.pendingCrops.addAll(harvested);
                    this.harvestProvider = logic;
                }
            } else if (this.stage == Stage.CULTIVATE) {
                farmWorkStatus = this.cultivateTargets(farmWorkStatus, farmTargets, logic);
            }
            if (farmWorkStatus.didWork) break;
        }
        if (this.stage == Stage.CULTIVATE) {
            errorLogic.setCondition(!farmWorkStatus.hasFarmland, EnumErrorCode.NO_FARMLAND);
            errorLogic.setCondition(!farmWorkStatus.hasFertilizer, EnumErrorCode.NO_FERTILIZER);
            errorLogic.setCondition(!farmWorkStatus.hasLiquid, EnumErrorCode.NO_LIQUID_FARM);
        }
        this.stage = this.stage.next();
        return farmWorkStatus.didWork;
    }

    private void setUpFarmlandTargets() {
        Vect targetStart = new Vect(this.getCoords());
        ChunkCoordinates max = this.getMaximumCoord();
        ChunkCoordinates min = this.getMinimumCoord();
        int sizeNorthSouth = Math.abs(max.posZ - min.posZ) + 1;
        int sizeEastWest = Math.abs(max.posX - min.posX) + 1;
        this.allowedExtent = Math.max(sizeNorthSouth, sizeEastWest) * Config.farmSize + 1;
        FarmController.createTargets(this.worldObj, this.targets, targetStart, this.allowedExtent, sizeNorthSouth, sizeEastWest);
        FarmController.setExtents(this.worldObj, this.targets);
    }

    private static void createTargets(World world, Map<FarmDirection, List<FarmTarget>> targets, Vect targetStart, int allowedExtent, int farmSizeNorthSouth, int farmSizeEastWest) {
        for (FarmDirection farmSide : FarmDirection.values()) {
            int farmWidth = farmSide == FarmDirection.NORTH || farmSide == FarmDirection.SOUTH ? farmSizeEastWest : farmSizeNorthSouth;
            int targetMaxLimit = allowedExtent + farmWidth;
            FarmDirection layoutDirection = FarmController.getLayoutDirection(farmSide);
            Vect targetLocation = FarmHelper.getFarmMultiblockCorner(world, targetStart, farmSide, layoutDirection);
            Vect firstLocation = targetLocation.add(farmSide);
            Vect firstGroundPosition = FarmController.getGroundPosition(world, firstLocation);
            if (firstGroundPosition == null) continue;
            int groundHeight = firstGroundPosition.getY();
            ArrayList<FarmTarget> farmSideTargets = new ArrayList<FarmTarget>();
            for (int i = 0; i < allowedExtent; ++i) {
                Block platform;
                targetLocation = targetLocation.add(farmSide);
                Vect groundLocation = new Vect(targetLocation.getX(), groundHeight, targetLocation.getZ());
                int targetLimit = targetMaxLimit;
                if (!Config.squareFarms) {
                    targetLimit = targetMaxLimit - i - 1;
                }
                if (!FarmHelper.bricks.contains((Object)(platform = VectUtil.getBlock(world, groundLocation)))) break;
                FarmTarget target = new FarmTarget(targetLocation, layoutDirection, targetLimit);
                farmSideTargets.add(target);
            }
            targets.put(farmSide, farmSideTargets);
        }
    }

    private static Vect getGroundPosition(World world, Vect targetPosition) {
        for (int yOffset = 2; yOffset > -4; --yOffset) {
            Vect position = targetPosition.add(0, yOffset, 0);
            Block ground = VectUtil.getBlock(world, position);
            if (!FarmHelper.bricks.contains((Object)ground)) continue;
            return position;
        }
        return null;
    }

    private static boolean isCycleCanceledByListeners(IFarmLogic logic, FarmDirection direction, Iterable<IFarmListener> farmListeners) {
        for (IFarmListener listener : farmListeners) {
            if (!listener.cancelTask(logic, direction)) continue;
            return true;
        }
        return false;
    }

    private static void setExtents(World worldObj, Map<FarmDirection, List<FarmTarget>> targets) {
        for (List<FarmTarget> targetsList : targets.values()) {
            if (targetsList.isEmpty()) continue;
            Vect groundPosition = FarmController.getGroundPosition(worldObj, targetsList.get(0).getStart());
            for (FarmTarget target : targetsList) {
                target.setExtentAndYOffset(worldObj, groundPosition);
            }
        }
    }

    private FarmWorkStatus cultivateTargets(FarmWorkStatus farmWorkStatus, List<FarmTarget> farmTargets, IFarmLogic logic) {
        float hydrationModifier = this.hydrationManager.getHydrationModifier();
        int fertilizerConsumption = logic.getFertilizerConsumption();
        int liquidConsumption = logic.getWaterConsumption(hydrationModifier);
        FluidStack liquid = Fluids.WATER.getFluid(liquidConsumption);
        if (farmTargets != null) {
            for (FarmTarget target : farmTargets) {
                if (target.getExtent() <= 0) break;
                farmWorkStatus.hasFarmland = true;
                if (!this.fertilizerManager.hasFertilizer(fertilizerConsumption) || liquid.amount > 0 && !this.hasLiquid(liquid) || !FarmController.cultivateTarget(target, logic, this.farmListeners)) continue;
                this.fertilizerManager.removeFertilizer(fertilizerConsumption);
                this.removeLiquid(liquid);
                farmWorkStatus.didWork = true;
            }
        }
        farmWorkStatus.hasLiquid = liquid.amount <= 0 || this.hasLiquid(liquid);
        farmWorkStatus.hasFertilizer = this.fertilizerManager.hasFertilizer(fertilizerConsumption);
        return farmWorkStatus;
    }

    private static boolean cultivateTarget(FarmTarget target, IFarmLogic logic, Iterable<IFarmListener> farmListeners) {
        Vect targetPosition = target.getStart().add(0, target.getYOffset(), 0);
        if (logic.cultivate(targetPosition.x, targetPosition.y, targetPosition.z, target.getDirection(), target.getExtent())) {
            for (IFarmListener listener : farmListeners) {
                listener.hasCultivated(logic, targetPosition.x, targetPosition.y, targetPosition.z, target.getDirection(), target.getExtent());
            }
            return true;
        }
        return false;
    }

    private static Collection<ICrop> harvestTargets(List<FarmTarget> farmTargets, IFarmLogic logic, Iterable<IFarmListener> farmListeners) {
        if (farmTargets != null) {
            for (FarmTarget target : farmTargets) {
                Collection<ICrop> harvested = FarmController.harvestTarget(target, logic, farmListeners);
                if (harvested.size() <= 0) continue;
                return harvested;
            }
        }
        return Collections.emptyList();
    }

    private static Collection<ICrop> harvestTarget(FarmTarget target, IFarmLogic logic, Iterable<IFarmListener> farmListeners) {
        Collection<ICrop> harvested = logic.harvest(target.getStart().x, target.getStart().y + target.getYOffset(), target.getStart().z, target.getDirection(), target.getExtent());
        if (harvested == null || harvested.size() == 0) {
            return Collections.emptyList();
        }
        for (IFarmListener listener : farmListeners) {
            listener.hasScheduledHarvest(harvested, logic, target.getStart().x, target.getStart().y + target.getYOffset(), target.getStart().z, target.getDirection(), target.getExtent());
        }
        return harvested;
    }

    private boolean collectWindfall(IFarmLogic logic) {
        Collection<ItemStack> collected = logic.collect();
        if (collected == null || collected.size() <= 0) {
            return false;
        }
        for (IFarmListener listener : this.farmListeners) {
            listener.hasCollected(collected, logic);
        }
        for (ItemStack produce : collected) {
            this.inventory.addProduce(produce);
            this.pendingProduce.push(produce);
        }
        return true;
    }

    private boolean cullCrop(ICrop crop, IFarmLogic provider) {
        Boolean hasFertilizer;
        for (IFarmListener listener : this.farmListeners) {
            if (!listener.beforeCropHarvest(crop)) continue;
            return true;
        }
        int fertilizerConsumption = provider.getFertilizerConsumption();
        IErrorLogic errorLogic = this.getErrorLogic();
        if (errorLogic.setCondition((hasFertilizer = Boolean.valueOf(this.fertilizerManager.hasFertilizer(fertilizerConsumption))) == false, EnumErrorCode.NO_FERTILIZER)) {
            return false;
        }
        float hydrationModifier = this.hydrationManager.getHydrationModifier();
        int waterConsumption = provider.getWaterConsumption(hydrationModifier);
        FluidStack requiredLiquid = Fluids.WATER.getFluid(waterConsumption);
        boolean hasLiquid = requiredLiquid.amount == 0 || this.hasLiquid(requiredLiquid);
        if (errorLogic.setCondition(!hasLiquid, EnumErrorCode.NO_LIQUID_FARM)) {
            return false;
        }
        Collection<ItemStack> harvested = crop.harvest();
        if (harvested == null) {
            Log.fine("Failed to harvest crop: " + crop);
            return true;
        }
        this.fertilizerManager.removeFertilizer(fertilizerConsumption);
        this.removeLiquid(requiredLiquid);
        for (IFarmListener listener : this.farmListeners) {
            listener.afterCropHarvest(harvested, crop);
        }
        this.inventory.stowHarvest(harvested, this.pendingProduce);
        return true;
    }

    @Override
    public int getStoredFertilizerScaled(int scale) {
        return this.fertilizerManager.getStoredFertilizerScaled(scale);
    }

    @Override
    public boolean hasLiquid(FluidStack liquid) {
        return this.resourceTank.canDrain(liquid);
    }

    @Override
    public void removeLiquid(FluidStack liquid) {
        this.resourceTank.drain(liquid.amount, true);
    }

    @Override
    public boolean plantGermling(IFarmable germling, World world, int x, int y, int z) {
        EntityPlayer player = PlayerUtil.getPlayer(world, this.getAccessHandler().getOwner());
        return this.inventory.plantGermling(germling, player, x, y, z);
    }

    @Override
    public IFarmInventory getFarmInventory() {
        return this.inventory;
    }

    @Override
    public void setFarmLogic(FarmDirection direction, IFarmLogic logic) {
        if (logic == null) {
            throw new NullPointerException("logic must not be null");
        }
        this.farmLogics.put(direction, logic);
    }

    @Override
    public void resetFarmLogic(FarmDirection direction) {
        this.setFarmLogic(direction, new FarmLogicArboreal(this));
    }

    @Override
    public IFarmLogic getFarmLogic(FarmDirection direction) {
        return this.farmLogics.get((Object)direction);
    }

    @Override
    public int getSocketCount() {
        return this.sockets.getSizeInventory();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.sockets.getStackInSlot(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        ICircuitBoard chipset;
        if (stack != null && !ChipsetManager.circuitRegistry.isChipset(stack)) {
            return;
        }
        if (this.sockets.getStackInSlot(slot) != null && ChipsetManager.circuitRegistry.isChipset(this.sockets.getStackInSlot(slot)) && (chipset = ChipsetManager.circuitRegistry.getCircuitboard(this.sockets.getStackInSlot(slot))) != null) {
            chipset.onRemoval(this);
        }
        this.sockets.setInventorySlotContents(slot, stack);
        this.refreshFarmLogics();
        if (stack == null) {
            return;
        }
        chipset = ChipsetManager.circuitRegistry.getCircuitboard(stack);
        if (chipset != null) {
            chipset.onInsertion(this);
        }
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return CircuitSocketType.FARM;
    }

    private static class FarmWorkStatus {
        public boolean didWork = false;
        public boolean hasFarmland = false;
        public boolean hasFertilizer = false;
        public boolean hasLiquid = false;

        private FarmWorkStatus() {
        }
    }

    private static enum Stage {
        CULTIVATE,
        HARVEST;


        public Stage next() {
            if (this == CULTIVATE) {
                return HARVEST;
            }
            return CULTIVATE;
        }
    }
}

