/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockLogic;
import forestry.core.multiblock.MultiblockRegistry;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.utils.Log;
import forestry.core.utils.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class MultiblockControllerBase
implements IMultiblockControllerInternal {
    protected World worldObj;
    private static final Random rand = new Random();
    private int tickCount = rand.nextInt(256);
    protected AssemblyState assemblyState;
    protected HashSet<IMultiblockComponent> connectedParts;
    private ChunkCoordinates referenceCoord;
    private ChunkCoordinates minimumCoord;
    private ChunkCoordinates maximumCoord;
    private boolean shouldCheckForDisconnections;
    private MultiblockValidationException lastValidationException;

    protected MultiblockControllerBase(World world) {
        this.worldObj = world;
        this.connectedParts = new HashSet();
        this.referenceCoord = null;
        this.assemblyState = AssemblyState.Disassembled;
        this.minimumCoord = null;
        this.maximumCoord = null;
        this.shouldCheckForDisconnections = true;
        this.lastValidationException = null;
    }

    @Override
    @Nonnull
    public Collection<IMultiblockComponent> getComponents() {
        return Collections.unmodifiableCollection(this.connectedParts);
    }

    protected abstract void onAttachedPartWithMultiblockData(IMultiblockComponent var1, NBTTagCompound var2);

    @Override
    public void attachBlock(IMultiblockComponent part) {
        ChunkCoordinates coord = part.getCoordinates();
        if (!this.connectedParts.add(part)) {
            Log.warning("[%s] Controller %s is double-adding part %d @ %s. This is unusual. If you encounter odd behavior, please tear down the machine and rebuild it.", this.worldObj.isRemote ? "CLIENT" : "SERVER", this.hashCode(), part.hashCode(), coord);
        }
        MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
        logic.setController(this);
        this.onBlockAdded(part);
        if (logic.hasMultiblockSaveData()) {
            NBTTagCompound savedData = logic.getMultiblockSaveData();
            this.onAttachedPartWithMultiblockData(part, savedData);
            logic.onMultiblockDataAssimilated();
        }
        if (this.referenceCoord == null) {
            this.referenceCoord = coord;
            logic.becomeMultiblockSaveDelegate();
        } else if (coord.compareTo(this.referenceCoord) < 0) {
            TileEntity te = this.worldObj.getTileEntity(this.referenceCoord.posX, this.referenceCoord.posY, this.referenceCoord.posZ);
            if (te instanceof IMultiblockComponent) {
                IMultiblockComponent tePart = (IMultiblockComponent)te;
                MultiblockLogic teLogic = (MultiblockLogic)tePart.getMultiblockLogic();
                teLogic.forfeitMultiblockSaveDelegate();
            }
            this.referenceCoord = coord;
            logic.becomeMultiblockSaveDelegate();
        } else {
            logic.forfeitMultiblockSaveDelegate();
        }
        if (this.minimumCoord != null) {
            if (coord.posX < this.minimumCoord.posX) {
                this.minimumCoord.posX = coord.posX;
            }
            if (coord.posY < this.minimumCoord.posY) {
                this.minimumCoord.posY = coord.posY;
            }
            if (coord.posZ < this.minimumCoord.posZ) {
                this.minimumCoord.posZ = coord.posZ;
            }
        }
        if (this.maximumCoord != null) {
            if (coord.posX > this.maximumCoord.posX) {
                this.maximumCoord.posX = coord.posX;
            }
            if (coord.posY > this.maximumCoord.posY) {
                this.maximumCoord.posY = coord.posY;
            }
            if (coord.posZ > this.maximumCoord.posZ) {
                this.maximumCoord.posZ = coord.posZ;
            }
        }
        MultiblockRegistry.addDirtyController(this.worldObj, this);
    }

    protected abstract void onBlockAdded(IMultiblockComponent var1);

    protected abstract void onBlockRemoved(IMultiblockComponent var1);

    protected void onMachineAssembled() {
    }

    protected void onMachineRestored() {
    }

    protected void onMachinePaused() {
    }

    protected void onMachineDisassembled() {
    }

    private void onDetachBlock(IMultiblockComponent part) {
        MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
        logic.setController(null);
        this.onBlockRemoved(part);
        logic.forfeitMultiblockSaveDelegate();
        this.maximumCoord = null;
        this.minimumCoord = null;
        if (this.referenceCoord != null && this.referenceCoord.equals((Object)part.getCoordinates())) {
            this.referenceCoord = null;
        }
        this.shouldCheckForDisconnections = true;
    }

    @Override
    public void detachBlock(IMultiblockComponent part, boolean chunkUnloading) {
        if (chunkUnloading && this.assemblyState == AssemblyState.Assembled) {
            this.assemblyState = AssemblyState.Paused;
            this.onMachinePaused();
        }
        this.onDetachBlock(part);
        if (!this.connectedParts.remove(part)) {
            ChunkCoordinates partCoords = part.getCoordinates();
            Log.warning("[%s] Double-removing part (%d) @ %d, %d, %d, this is unexpected and may cause problems. If you encounter anomalies, please tear down the reactor and rebuild it.", this.worldObj.isRemote ? "CLIENT" : "SERVER", part.hashCode(), partCoords.posX, partCoords.posY, partCoords.posZ);
        }
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return;
        }
        MultiblockRegistry.addDirtyController(this.worldObj, this);
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
    }

    @Override
    public String getLastValidationError() {
        if (this.lastValidationException == null) {
            return null;
        }
        return this.lastValidationException.getMessage();
    }

    @Override
    public void reassemble() {
        MultiblockRegistry.addDirtyController(this.worldObj, this);
    }

    protected abstract void isMachineWhole() throws MultiblockValidationException;

    @Override
    public void checkIfMachineIsWhole() {
        boolean isWhole;
        AssemblyState oldState = this.assemblyState;
        this.lastValidationException = null;
        try {
            this.isMachineWhole();
            isWhole = true;
        }
        catch (MultiblockValidationException e) {
            this.lastValidationException = e;
            isWhole = false;
        }
        if (isWhole) {
            this.assembleMachine(oldState);
        } else if (oldState == AssemblyState.Assembled) {
            this.disassembleMachine();
        }
    }

    private void assembleMachine(AssemblyState oldState) {
        this.assemblyState = AssemblyState.Assembled;
        for (IMultiblockComponent part : this.connectedParts) {
            part.onMachineAssembled(this, this.getMinimumCoord(), this.getMaximumCoord());
        }
        if (oldState == AssemblyState.Paused) {
            this.onMachineRestored();
        } else {
            this.onMachineAssembled();
        }
    }

    private void disassembleMachine() {
        this.assemblyState = AssemblyState.Disassembled;
        for (IMultiblockComponent part : this.connectedParts) {
            part.onMachineBroken();
        }
        this.onMachineDisassembled();
    }

    @Override
    public void assimilate(IMultiblockControllerInternal other) {
        ChunkCoordinates otherReferenceCoord = other.getReferenceCoord();
        if (otherReferenceCoord != null && this.getReferenceCoord().compareTo(otherReferenceCoord) >= 0) {
            throw new IllegalArgumentException("The controller with the lowest minimum-coord value must consume the one with the higher coords");
        }
        HashSet<IMultiblockComponent> partsToAcquire = new HashSet<IMultiblockComponent>(other.getComponents());
        other._onAssimilated(this);
        for (IMultiblockComponent acquiredPart : partsToAcquire) {
            if (acquiredPart.isInvalid()) continue;
            this.connectedParts.add(acquiredPart);
            MultiblockLogic logic = (MultiblockLogic)acquiredPart.getMultiblockLogic();
            logic.setController(this);
            this.onBlockAdded(acquiredPart);
        }
        this.onAssimilate(other);
        other.onAssimilated(this);
    }

    @Override
    public void _onAssimilated(IMultiblockControllerInternal otherController) {
        if (this.referenceCoord != null) {
            TileEntity te;
            if (this.worldObj.getChunkProvider().chunkExists(this.referenceCoord.posX >> 4, this.referenceCoord.posZ >> 4) && (te = this.worldObj.getTileEntity(this.referenceCoord.posX, this.referenceCoord.posY, this.referenceCoord.posZ)) instanceof IMultiblockComponent) {
                IMultiblockComponent part = (IMultiblockComponent)te;
                MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
                logic.forfeitMultiblockSaveDelegate();
            }
            this.referenceCoord = null;
        }
        this.connectedParts.clear();
    }

    protected abstract void onAssimilate(IMultiblockControllerInternal var1);

    @Override
    public abstract void onAssimilated(IMultiblockControllerInternal var1);

    @Override
    public final void updateMultiblockEntity() {
        ++this.tickCount;
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return;
        }
        if (this.assemblyState != AssemblyState.Assembled) {
            return;
        }
        if (this.worldObj.isRemote) {
            this.updateClient(this.tickCount);
        } else if (this.updateServer(this.tickCount) && this.minimumCoord != null && this.maximumCoord != null && this.worldObj.checkChunksExist(this.minimumCoord.posX, this.minimumCoord.posY, this.minimumCoord.posZ, this.maximumCoord.posX, this.maximumCoord.posY, this.maximumCoord.posZ)) {
            int minChunkX = this.minimumCoord.posX >> 4;
            int minChunkZ = this.minimumCoord.posZ >> 4;
            int maxChunkX = this.maximumCoord.posX >> 4;
            int maxChunkZ = this.maximumCoord.posZ >> 4;
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    Chunk chunkToSave = this.worldObj.getChunkFromChunkCoords(x, z);
                    chunkToSave.setChunkModified();
                }
            }
        }
    }

    protected abstract boolean updateServer(int var1);

    protected abstract void updateClient(int var1);

    protected final boolean updateOnInterval(int tickInterval) {
        return this.tickCount % tickInterval == 0;
    }

    protected void isBlockGoodForExteriorLevel(int level, World world, int x, int y, int z) throws MultiblockValidationException {
        Block block = world.getBlock(x, y, z);
        throw new MultiblockValidationException(StringUtil.localizeAndFormatRaw("for.multiblock.error.invalid.interior", x, y, z, block.getLocalizedName()));
    }

    protected void isBlockGoodForInterior(World world, int x, int y, int z) throws MultiblockValidationException {
        Block block = world.getBlock(x, y, z);
        throw new MultiblockValidationException(StringUtil.localizeAndFormatRaw("for.multiblock.error.invalid.interior", x, y, z, block.getLocalizedName()));
    }

    @Override
    public ChunkCoordinates getReferenceCoord() {
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        return this.referenceCoord;
    }

    public int getNumConnectedBlocks() {
        return this.connectedParts.size();
    }

    @Override
    public void recalculateMinMaxCoords() {
        this.minimumCoord = new ChunkCoordinates(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.maximumCoord = new ChunkCoordinates(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (IMultiblockComponent part : this.connectedParts) {
            ChunkCoordinates partCoords = part.getCoordinates();
            if (partCoords.posX < this.minimumCoord.posX) {
                this.minimumCoord.posX = partCoords.posX;
            }
            if (partCoords.posX > this.maximumCoord.posX) {
                this.maximumCoord.posX = partCoords.posX;
            }
            if (partCoords.posY < this.minimumCoord.posY) {
                this.minimumCoord.posY = partCoords.posY;
            }
            if (partCoords.posY > this.maximumCoord.posY) {
                this.maximumCoord.posY = partCoords.posY;
            }
            if (partCoords.posZ < this.minimumCoord.posZ) {
                this.minimumCoord.posZ = partCoords.posZ;
            }
            if (partCoords.posZ <= this.maximumCoord.posZ) continue;
            this.maximumCoord.posZ = partCoords.posZ;
        }
    }

    protected ChunkCoordinates getMinimumCoord() {
        if (this.minimumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return new ChunkCoordinates(this.minimumCoord);
    }

    protected ChunkCoordinates getMaximumCoord() {
        if (this.maximumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return new ChunkCoordinates(this.maximumCoord);
    }

    protected final ChunkCoordinates getCenterCoord() {
        ChunkCoordinates minCoord = this.getMinimumCoord();
        ChunkCoordinates maxCoord = this.getMaximumCoord();
        return new ChunkCoordinates((minCoord.posX + maxCoord.posX) / 2, (minCoord.posY + maxCoord.posY) / 2, (minCoord.posZ + maxCoord.posZ) / 2);
    }

    protected final ChunkCoordinates getTopCenterCoord() {
        ChunkCoordinates minCoord = this.getMinimumCoord();
        ChunkCoordinates maxCoord = this.getMaximumCoord();
        return new ChunkCoordinates((minCoord.posX + maxCoord.posX) / 2, maxCoord.posY, (minCoord.posZ + maxCoord.posZ) / 2);
    }

    protected final boolean isCoordInMultiblock(int x, int y, int z) {
        return x >= this.minimumCoord.posX && x <= this.maximumCoord.posX && y >= this.minimumCoord.posY && y <= this.maximumCoord.posY && z >= this.minimumCoord.posZ && z <= this.maximumCoord.posZ;
    }

    @Override
    public boolean isEmpty() {
        return this.connectedParts.isEmpty();
    }

    @Override
    public boolean shouldConsume(IMultiblockControllerInternal otherController) {
        if (!otherController.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Attempting to merge two multiblocks with different master classes - this should never happen!");
        }
        if (otherController == this) {
            return false;
        }
        int res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        Log.warning("[%s] Encountered two controllers with the same reference coordinate. Auditing connected parts and retrying.", (Object)(this.worldObj.isRemote ? "CLIENT" : "SERVER"));
        this.auditParts();
        otherController.auditParts();
        res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        Log.severe("My Controller (%d): size (%d), parts: %s", this.hashCode(), this.connectedParts.size(), this.getPartsListString());
        Log.severe("Other Controller (%d): size (%d), coords: %s", otherController.hashCode(), otherController.getComponents().size(), otherController.getPartsListString());
        throw new IllegalArgumentException("[" + (this.worldObj.isRemote ? "CLIENT" : "SERVER") + "] " + "Two controllers with the same reference coord that somehow both have valid parts - this should never happen!");
    }

    private int _shouldConsume(IMultiblockControllerInternal otherController) {
        ChunkCoordinates myCoord = this.getReferenceCoord();
        ChunkCoordinates theirCoord = otherController.getReferenceCoord();
        if (theirCoord == null) {
            return -1;
        }
        return myCoord.compareTo(theirCoord);
    }

    @Override
    public String getPartsListString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IMultiblockComponent part : this.connectedParts) {
            if (!first) {
                sb.append(", ");
            }
            ChunkCoordinates partCoord = part.getCoordinates();
            sb.append(String.format("(%d: %d, %d, %d)", part.hashCode(), partCoord.posX, partCoord.posY, partCoord.posZ));
            first = false;
        }
        return sb.toString();
    }

    @Override
    public void auditParts() {
        HashSet<IMultiblockComponent> deadParts = new HashSet<IMultiblockComponent>();
        for (IMultiblockComponent part : this.connectedParts) {
            ChunkCoordinates partCoord = part.getCoordinates();
            if (!part.isInvalid() && this.worldObj.getTileEntity(partCoord.posX, partCoord.posY, partCoord.posZ) == part) continue;
            this.onDetachBlock(part);
            deadParts.add(part);
        }
        this.connectedParts.removeAll(deadParts);
        Log.warning("[%s] Controller found %d dead parts during an audit, %d parts remain attached", this.worldObj.isRemote ? "CLIENT" : "SERVER", deadParts.size(), this.connectedParts.size());
    }

    @Override
    @Nonnull
    public Set<IMultiblockComponent> checkForDisconnections() {
        if (!this.shouldCheckForDisconnections) {
            return Collections.emptySet();
        }
        if (this.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return Collections.emptySet();
        }
        IChunkProvider chunkProvider = this.worldObj.getChunkProvider();
        this.referenceCoord = null;
        HashSet<IMultiblockComponent> deadParts = new HashSet<IMultiblockComponent>();
        IMultiblockComponent referencePart = null;
        int originalSize = this.connectedParts.size();
        for (IMultiblockComponent part : this.connectedParts) {
            ChunkCoordinates partCoord = part.getCoordinates();
            if (!chunkProvider.chunkExists(partCoord.posX >> 4, partCoord.posZ >> 4) || part.isInvalid()) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            if (this.worldObj.getTileEntity(partCoord.posX, partCoord.posY, partCoord.posZ) != part) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
            logic.setUnvisited();
            logic.forfeitMultiblockSaveDelegate();
            ChunkCoordinates c = part.getCoordinates();
            if (this.referenceCoord == null) {
                this.referenceCoord = c;
                referencePart = part;
                continue;
            }
            if (c.compareTo(this.referenceCoord) >= 0) continue;
            this.referenceCoord = c;
            referencePart = part;
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (referencePart == null || this.isEmpty()) {
            this.shouldCheckForDisconnections = false;
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return Collections.emptySet();
        }
        MultiblockLogic logic = (MultiblockLogic)referencePart.getMultiblockLogic();
        logic.becomeMultiblockSaveDelegate();
        LinkedList<IMultiblockComponent> partsToCheck = new LinkedList<IMultiblockComponent>();
        partsToCheck.add(referencePart);
        while (!partsToCheck.isEmpty()) {
            IMultiblockComponent part = (IMultiblockComponent)partsToCheck.removeFirst();
            MultiblockLogic partLogic = (MultiblockLogic)part.getMultiblockLogic();
            partLogic.setVisited();
            List<IMultiblockComponent> nearbyParts = MultiblockUtil.getNeighboringParts(this.worldObj, part);
            for (IMultiblockComponent nearbyPart : nearbyParts) {
                MultiblockLogic nearbyPartLogic = (MultiblockLogic)nearbyPart.getMultiblockLogic();
                if (nearbyPartLogic.getController() != this || nearbyPartLogic.isVisited()) continue;
                nearbyPartLogic.setVisited();
                partsToCheck.add(nearbyPart);
            }
        }
        HashSet<IMultiblockComponent> removedParts = new HashSet<IMultiblockComponent>();
        for (IMultiblockComponent orphanCandidate : this.connectedParts) {
            MultiblockLogic logic2 = (MultiblockLogic)orphanCandidate.getMultiblockLogic();
            if (logic2.isVisited()) continue;
            deadParts.add(orphanCandidate);
            this.onDetachBlock(orphanCandidate);
            removedParts.add(orphanCandidate);
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        this.shouldCheckForDisconnections = false;
        return removedParts;
    }

    @Override
    @Nonnull
    public Set<IMultiblockComponent> detachAllBlocks() {
        if (this.worldObj == null) {
            return new HashSet<IMultiblockComponent>();
        }
        IChunkProvider chunkProvider = this.worldObj.getChunkProvider();
        for (IMultiblockComponent part : this.connectedParts) {
            ChunkCoordinates partCoord = part.getCoordinates();
            if (!chunkProvider.chunkExists(partCoord.posX >> 4, partCoord.posZ >> 4)) continue;
            this.onDetachBlock(part);
        }
        HashSet<IMultiblockComponent> detachedParts = this.connectedParts;
        this.connectedParts = new HashSet();
        return detachedParts;
    }

    @Override
    public boolean isAssembled() {
        return this.assemblyState == AssemblyState.Assembled;
    }

    private void selectNewReferenceCoord() {
        IChunkProvider chunkProvider = this.worldObj.getChunkProvider();
        IMultiblockComponent theChosenOne = null;
        this.referenceCoord = null;
        for (IMultiblockComponent part : this.connectedParts) {
            ChunkCoordinates partCoord = part.getCoordinates();
            if (part.isInvalid() || !chunkProvider.chunkExists(partCoord.posX >> 4, partCoord.posZ >> 4) || this.referenceCoord != null && this.referenceCoord.compareTo(partCoord) <= 0) continue;
            this.referenceCoord = part.getCoordinates();
            theChosenOne = part;
        }
        if (theChosenOne != null) {
            MultiblockLogic logic = (MultiblockLogic)theChosenOne.getMultiblockLogic();
            logic.becomeMultiblockSaveDelegate();
        }
    }

    protected void markReferenceCoordForUpdate() {
        ChunkCoordinates rc = this.getReferenceCoord();
        if (this.worldObj != null && rc != null) {
            this.worldObj.markBlockForUpdate(rc.posX, rc.posY, rc.posZ);
        }
    }

    protected void markReferenceCoordDirty() {
        if (this.worldObj == null || this.worldObj.isRemote) {
            return;
        }
        ChunkCoordinates referenceCoord = this.getReferenceCoord();
        if (referenceCoord == null) {
            return;
        }
        TileEntity saveTe = this.worldObj.getTileEntity(referenceCoord.posX, referenceCoord.posY, referenceCoord.posZ);
        this.worldObj.markTileEntityChunkModified(referenceCoord.posX, referenceCoord.posY, referenceCoord.posZ, saveTe);
    }

    protected static enum AssemblyState {
        Disassembled,
        Assembled,
        Paused;

    }
}

