/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.gui.ContainerNaturalistInventory;
import forestry.core.gui.GuiNaturalistInventory;
import forestry.core.network.GuiId;
import forestry.core.tiles.TileNaturalistChest;
import forestry.core.tiles.TileUtil;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class GuiHandlerBase
implements IGuiHandler {
    public abstract Container getServerGuiElement(int var1, EntityPlayer var2, World var3, int var4, int var5, int var6);

    @SideOnly(value=Side.CLIENT)
    public abstract Gui getClientGuiElement(int var1, EntityPlayer var2, World var3, int var4, int var5, int var6);

    protected GuiNaturalistInventory getNaturalistChestGui(ISpeciesRoot speciesRoot, EntityPlayer player, World world, int x, int y, int z, int page) {
        TileNaturalistChest tile = TileUtil.getTile((IBlockAccess)world, x, y, z, TileNaturalistChest.class);
        return new GuiNaturalistInventory(speciesRoot, player, new ContainerNaturalistInventory(player.inventory, tile, page), tile, page, 5);
    }

    protected ContainerNaturalistInventory getNaturalistChestContainer(ISpeciesRoot speciesRoot, EntityPlayer player, World world, int x, int y, int z, int page) {
        speciesRoot.getBreedingTracker(world, player.getGameProfile()).synchToPlayer(player);
        return new ContainerNaturalistInventory(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileNaturalistChest.class), page);
    }

    public static int encodeGuiData(GuiId guiId, int data) {
        return data << 8 | guiId.ordinal();
    }

    protected static int decodeGuiID(int guiId) {
        return guiId & 0xFF;
    }

    protected static int decodeGuiData(int guiId) {
        return guiId >> 8;
    }
}

