/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import forestry.Forestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class Version {
    public static final String VERSION = "4.2.0.817-unstable";
    public static final String BUILD_NUMBER = "817";
    public static final String[] FAILED_CHANGELOG = new String[]{String.format("Unable to retrieve changelog for %s", "Forestry")};
    private static final String REMOTE_VERSION_FILE = "http://bit.ly/forestryver";
    private static final String REMOTE_CHANGELOG_ROOT = "https://dl.dropbox.com/u/44760587/forestry/changelog/";
    public static EnumUpdateState currentVersion = EnumUpdateState.CURRENT;
    private static String recommendedVersion;
    private static String[] cachedChangelog;

    public static String getVersion() {
        return "4.2.0.817-unstable (817)";
    }

    public static boolean isOutdated() {
        return currentVersion == EnumUpdateState.OUTDATED;
    }

    public static boolean needsUpdateNoticeAndMarkAsSeen() {
        if (!Version.isOutdated()) {
            return false;
        }
        File versionFile = new File(Forestry.instance.getConfigFolder(), "common.cfg");
        Configuration config = new Configuration(versionFile);
        Property property = config.get("version", "seen", VERSION);
        property.comment = "indicates the last version the user has been informed about and will suppress further notices on it.";
        String seenVersion = property.getString();
        if (recommendedVersion == null || recommendedVersion.equals(seenVersion)) {
            return false;
        }
        property.set(recommendedVersion);
        config.save();
        return true;
    }

    public static String getRecommendedVersion() {
        return recommendedVersion;
    }

    public static void versionCheck() {
        new VersionChecker().start();
    }

    public static String[] getChangelog() {
        return cachedChangelog;
    }

    public static String[] grabChangelog(String version) {
        try {
            String line;
            HttpURLConnection conn;
            String location = REMOTE_CHANGELOG_ROOT + version;
            do {
                URL url = new URL(location);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                conn.connect();
            } while ((location = conn.getHeaderField("Location")) != null && !location.isEmpty());
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            ArrayList<String> changelog = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.isEmpty()) continue;
                changelog.add(line);
            }
            return changelog.toArray(new String[changelog.size()]);
        }
        catch (Exception ex) {
            Log.warning("Unable to read changelog from remote site.");
            return new String[]{String.format("Unable to retrieve changelog for %s %s", "Forestry", version)};
        }
    }

    static /* synthetic */ String[] access$102(String[] x0) {
        cachedChangelog = x0;
        return x0;
    }

    static {
        cachedChangelog = FAILED_CHANGELOG;
    }

    private static class VersionChecker
    extends Thread {
        private VersionChecker() {
        }

        @Override
        public void run() {
            try {
                String line;
                String location = Version.REMOTE_VERSION_FILE;
                URLConnection conn = null;
                while (location != null && !location.isEmpty()) {
                    URL url = new URL(location);
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; ru; rv:1.9.0.11) Gecko/2009060215 Firefox/3.0.11 (.NET CLR 3.5.30729)");
                    conn.connect();
                    location = conn.getHeaderField("Location");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String mcVersion = Proxies.common.getMinecraftVersion();
                while ((line = reader.readLine()) != null) {
                    if (!line.startsWith(mcVersion) || !line.contains("Forestry")) continue;
                    String[] tokens = line.split(":");
                    recommendedVersion = tokens[2];
                }
                if (recommendedVersion == null) {
                    return;
                }
                int result = FMLCommonHandler.instance().findContainerFor((Object)Forestry.instance).getProcessedVersion().compareTo((Object)new DefaultArtifactVersion(recommendedVersion));
                if (result >= 0) {
                    Log.finer("Using the latest version [4.2.0.817-unstable (build:817)] for Minecraft " + mcVersion);
                    currentVersion = EnumUpdateState.CURRENT;
                    return;
                }
                Version.access$102(Version.grabChangelog(recommendedVersion));
                Log.warning("Using outdated version [4.2.0.817-unstable (build:817)] for Minecraft " + mcVersion + ". Consider updating.");
                currentVersion = EnumUpdateState.OUTDATED;
            }
            catch (Exception e) {
                Log.warning("Unable to read from remote version authority.");
                currentVersion = EnumUpdateState.CONNECTION_ERROR;
            }
        }
    }

    public static enum EnumUpdateState {
        CURRENT,
        OUTDATED,
        CONNECTION_ERROR;

    }
}

