/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.Farmables;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ModUtil;
import forestry.farming.logic.FarmableBasicFruit;
import forestry.farming.logic.FarmableGenericCrop;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="Witchery", name="Witchery", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.witchery.description")
public class PluginWitchery
extends ForestryPlugin {
    private static final String Witch = "witchery";

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(Witch);
    }

    @Override
    public String getFailMessage() {
        return "Witchery not found";
    }

    @Override
    protected void registerRecipes() {
        ImmutableList flowersAccept = ImmutableList.of((Object)"bloodrose", (Object)"plantmine", (Object)"glintweed");
        ImmutableMap cropSeed = ImmutableMap.builder().put((Object)"belladonna", (Object)4).put((Object)"mandrake", (Object)4).put((Object)"mindrake", (Object)4).put((Object)"snowbell", (Object)4).put((Object)"wolfsbane", (Object)7).put((Object)"wormwood", (Object)4).build();
        ImmutableList cropDirect = ImmutableList.of((Object)"garlic");
        int seedamount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        Item saplingItem = GameRegistry.findItem((String)Witch, (String)"witchsapling");
        ItemStack saplingStack = new ItemStack(saplingItem, 1, Short.MAX_VALUE);
        RecipeUtil.addFermenterRecipes(saplingStack, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
        String saplingName = GameData.getItemRegistry().getNameForObject((Object)saplingItem);
        FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.-1", saplingName));
        for (String flowerAcceptName : flowersAccept) {
            Block flowerBlock = GameRegistry.findBlock((String)Witch, (String)flowerAcceptName);
            if (flowerBlock == null) continue;
            FlowerManager.flowerRegistry.registerAcceptableFlower(flowerBlock, "flowersVanilla");
        }
        for (String cropDirectName : cropDirect) {
            Block cropDirectBlock = GameRegistry.findBlock((String)Witch, (String)(cropDirectName + "plant"));
            ItemStack cropDirectStack = GameRegistry.findItemStack((String)Witch, (String)cropDirectName, (int)1);
            if (cropDirectStack == null || cropDirectBlock == null) continue;
            Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(cropDirectStack, cropDirectBlock, 5, new ItemStack[0]));
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(cropDirectBlock, 5));
        }
        for (Map.Entry cropSeedName : cropSeed.entrySet()) {
            Block cropSeedBlock = GameRegistry.findBlock((String)Witch, (String)((String)cropSeedName.getKey()));
            ItemStack cropSeedStack = GameRegistry.findItemStack((String)Witch, (String)("seeds" + (String)cropSeedName.getKey()), (int)1);
            if (cropSeedStack == null || cropSeedBlock == null) continue;
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{cropSeedStack}, Fluids.SEEDOIL.getFluid(seedamount));
            Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(cropSeedStack, cropSeedBlock, (Integer)cropSeedName.getValue(), new ItemStack[0]));
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(cropSeedBlock, (Integer)cropSeedName.getValue()));
        }
        Block artichokeBlock = GameRegistry.findBlock((String)Witch, (String)"artichoke");
        Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(artichokeBlock, 4));
    }
}

