/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.errors;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorState;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public enum EnumErrorCode implements IErrorState
{
    UNKNOWN("unknown"),
    WRONGSTACKSIZE("wrongStacksize"),
    NODISPOSAL("noDisposal"),
    INVALIDBIOME("invalidBiome"),
    ISRAINING("isRaining"),
    NOTRAINING("notRaining"),
    NOTGLOOMY("notGloomy"),
    NOTLUCID("notLucid"),
    NOTDAY("notDay"),
    NOTNIGHT("notNight"),
    NOFLOWER("noFlower"),
    NOQUEEN("noQueen"),
    NODRONE("noDrone"),
    NOSKY("noSky"),
    NORESOURCE("noResource"),
    NORECIPE("noRecipe"),
    NOSPACE("noSpace"),
    NOSPACETANK("noSpaceTank", "noLiquid"),
    NOHONEY("noHoney"),
    NOTHINGANALYZE("noSpecimen"),
    FORCEDCOOLDOWN("forcedCooldown"),
    NOFUEL("noFuel"),
    NOHEAT("noHeat"),
    NOENERGYNET("noEnergyNet"),
    NOSTAMPS("noStamps"),
    NOPAPER("noPaper"),
    NOSUPPLIES("noSupplies", "noResource"),
    NOTRADE("noTrade", "noResource"),
    NOTALPHANUMERIC("notAlphaNumeric"),
    NOTUNIQUE("notUnique"),
    NOTPOSTPAID("notPostpaid", "noStamps"),
    NORECIPIENT("noRecipient"),
    NOCIRCUITBOARD("noCircuitBoard"),
    NOCIRCUITLAYOUT("noCircuitLayout"),
    CIRCUITMISMATCH("circuitMismatch"),
    NOFERTILIZER("noFertilizer"),
    NOFARMLAND("noFarmland"),
    NOLIQUID("noLiquid"),
    NOPOWER("noPower"),
    NOREDSTONE("noRedstone", "disabled"),
    DISABLED("disabledRedstone", "disabled");

    private final String name;
    private final String iconName;
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;

    private EnumErrorCode(String name) {
        this(name, name);
    }

    private EnumErrorCode(String name, String iconName) {
        this.name = name;
        this.iconName = iconName;
    }

    @Override
    public String getDescription() {
        return "errors." + this.name + ".desc";
    }

    @Override
    public String getHelp() {
        return "errors." + this.name + ".help";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icon = register.registerIcon("forestry:errors/" + this.iconName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    public short getID() {
        return (short)this.ordinal();
    }

    @Override
    public String getUniqueName() {
        return "Forestry:" + this.name;
    }

    public static void init() {
        for (EnumErrorCode code : EnumErrorCode.values()) {
            ForestryAPI.errorStateRegistry.registerErrorState(code);
        }
    }
}

