/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBee;
import forestry.apiculture.inventory.InventorySwarmer;
import forestry.apiculture.multiblock.TileAlvearyWithGui;
import forestry.apiculture.network.PacketActiveUpdate;
import forestry.apiculture.worldgen.Hive;
import forestry.apiculture.worldgen.HiveDecorator;
import forestry.apiculture.worldgen.HiveDescriptionSwarmer;
import forestry.core.access.EnumAccess;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.ItemStackUtil;
import java.util.Map;
import java.util.Stack;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileAlvearySwarmer
extends TileAlvearyWithGui
implements ISidedInventory,
IActivatable,
IAlvearyComponent.Active {
    private final InventorySwarmer inventory;
    private final Stack<ItemStack> pendingSpawns = new Stack();
    private boolean active;

    public TileAlvearySwarmer() {
        super(2, GuiId.AlvearySwarmerGUI);
        this.inventory = new InventorySwarmer(this);
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    public boolean allowsAutomation() {
        return true;
    }

    @Override
    public void updateServer(int tickCount) {
        if (this.pendingSpawns.size() > 0) {
            this.setActive(true);
            if (tickCount % 1000 == 0) {
                this.trySpawnSwarm();
            }
        } else {
            this.setActive(false);
        }
        if (tickCount % 500 != 0) {
            return;
        }
        ItemStack princessStack = this.getPrincessStack();
        if (princessStack == null) {
            return;
        }
        int chance = this.consumeInducerAndGetChance();
        if (chance == 0) {
            return;
        }
        if (this.worldObj.rand.nextInt(1000) >= chance) {
            return;
        }
        IBee princess = BeeManager.beeRoot.getMember(princessStack);
        princess.setIsNatural(false);
        this.pendingSpawns.push(BeeManager.beeRoot.getMemberStack(princess, EnumBeeType.PRINCESS.ordinal()));
    }

    @Override
    public void updateClient(int tickCount) {
    }

    private ItemStack getPrincessStack() {
        ItemStack princessStack = this.getAlvearyController().getBeeInventory().getQueen();
        if (BeeManager.beeRoot.isMated(princessStack)) {
            return princessStack;
        }
        return null;
    }

    private int consumeInducerAndGetChance() {
        if (this.getInternalInventory() == null) {
            return 0;
        }
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)this.getInternalInventory())) {
            ItemStack stack = slot.getStackInSlot();
            for (Map.Entry<ItemStack, Integer> entry : BeeManager.inducers.entrySet()) {
                if (!ItemStackUtil.isIdenticalItem(entry.getKey(), stack)) continue;
                slot.decreaseStackInSlot();
                return entry.getValue();
            }
        }
        return 0;
    }

    private void trySpawnSwarm() {
        int chunkZ;
        ItemStack toSpawn = this.pendingSpawns.peek();
        HiveDescriptionSwarmer hiveDescription = new HiveDescriptionSwarmer(toSpawn);
        Hive hive = new Hive(hiveDescription);
        int chunkX = (this.xCoord + this.worldObj.rand.nextInt(80) - 40) / 16;
        if (HiveDecorator.genHive(this.worldObj, this.worldObj.rand, chunkX, chunkZ = (this.zCoord + this.worldObj.rand.nextInt(80) - 40) / 16, hive)) {
            this.pendingSpawns.pop();
        }
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.setBoolean("Active", this.active);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        this.setActive(packetData.getBoolean("Active"));
    }

    @Override
    public int getIcon(int side) {
        if (side == 0 || side == 1) {
            return 2;
        }
        if (this.active) {
            return 6;
        }
        return 5;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.setActive(nbttagcompound.getBoolean("Active"));
        NBTTagList nbttaglist = nbttagcompound.getTagList("PendingSpawns", 10);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
            this.pendingSpawns.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound1));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("Active", this.active);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] offspring = this.pendingSpawns.toArray(new ItemStack[this.pendingSpawns.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i);
            offspring[i].writeToNBT(nbttagcompound1);
            nbttaglist.appendTag((NBTBase)nbttagcompound1);
        }
        nbttagcompound.setTag("PendingSpawns", (NBTBase)nbttaglist);
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        if (oldAccess == EnumAccess.SHARED || newAccess == EnumAccess.SHARED) {
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.blockType);
            this.markDirty();
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (!this.worldObj.isRemote) {
            Proxies.net.sendNetworkPacket(new PacketActiveUpdate(this), this.worldObj);
        }
    }
}

