/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.core.INBTTagable;
import forestry.core.gui.ContainerDummy;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.InventoryPlain;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class RecipeMemory
implements INBTTagable,
IStreamable {
    public static final int capacity = 9;
    private static final Container DUMMY_CONTAINER = new ContainerDummy();
    private static final List<Class<? extends Item>> memoryBlacklist = new ArrayList<Class<? extends Item>>();
    private LinkedList<Recipe> recipes = new LinkedList();
    private long lastUpdate;

    private static boolean isValid(World world, Recipe recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack recipeOutput = recipe.getRecipeOutput(world);
        if (recipeOutput == null) {
            return false;
        }
        Item item = recipeOutput.getItem();
        return item != null && !memoryBlacklist.contains(item.getClass());
    }

    public void validate(World world) {
        LinkedList<Recipe> validRecipes = new LinkedList<Recipe>();
        for (Recipe recipe : this.recipes) {
            if (!RecipeMemory.isValid(world, recipe)) continue;
            validRecipes.add(recipe);
        }
        this.recipes = validRecipes;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void memorizeRecipe(World world, Recipe recipe, InventoryCrafting crafting) {
        if (!RecipeMemory.isValid(world, recipe)) {
            return;
        }
        this.lastUpdate = world.getTotalWorldTime();
        recipe.updateLastUse(this.lastUpdate);
        Recipe memory = this.getMemorized(crafting, world);
        if (memory != null) {
            if (memory.isLocked() != recipe.isLocked()) {
                recipe.toggleLock();
            }
            int index = this.recipes.indexOf(memory);
            this.recipes.set(index, recipe);
            return;
        }
        if (this.recipes.size() < 9) {
            this.recipes.add(recipe);
            return;
        }
        Recipe oldest = null;
        for (Recipe existing : this.recipes) {
            if (oldest != null && oldest.getLastUsed() < existing.getLastUsed() || existing.isLocked()) continue;
            oldest = existing;
        }
        if (oldest != null) {
            this.recipes.remove(oldest);
            this.recipes.add(recipe);
        }
    }

    private Recipe getRecipe(int recipeIndex) {
        if (this.recipes.size() > recipeIndex) {
            return this.recipes.get(recipeIndex);
        }
        return null;
    }

    public IInventory getRecipeMatrix(int recipeIndex) {
        Recipe recipe = this.getRecipe(recipeIndex);
        recipe.sanitizeMatrix();
        return recipe.getMatrix();
    }

    public ItemStack getRecipeOutput(World world, int recipeIndex) {
        if (this.recipes.size() > recipeIndex) {
            return this.recipes.get(recipeIndex).getRecipeOutput(world);
        }
        return null;
    }

    public boolean isLocked(int recipeIndex) {
        if (this.recipes.size() > recipeIndex) {
            return this.recipes.get(recipeIndex).isLocked();
        }
        return false;
    }

    public void toggleLock(World world, int recipeIndex) {
        this.lastUpdate = world.getTotalWorldTime();
        if (this.recipes.size() > recipeIndex) {
            this.recipes.get(recipeIndex).toggleLock();
        }
    }

    private Recipe getMemorized(InventoryCrafting crafting, World world) {
        for (Recipe recipe : this.recipes) {
            if (!recipe.hasSameOutput(crafting, world)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.recipes = new LinkedList();
        if (!nbttagcompound.hasKey("RecipeMemory")) {
            return;
        }
        NBTTagList nbttaglist = nbttagcompound.getTagList("RecipeMemory", 10);
        for (int j = 0; j < nbttaglist.tagCount(); ++j) {
            NBTTagCompound nbttagcompound2 = nbttaglist.getCompoundTagAt(j);
            this.recipes.add(new Recipe(nbttagcompound2));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (Recipe recipe : this.recipes) {
            if (recipe == null) continue;
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            recipe.writeToNBT(nbttagcompound2);
            nbttaglist.appendTag((NBTBase)nbttagcompound2);
        }
        nbttagcompound.setTag("RecipeMemory", (NBTBase)nbttaglist);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeStreamables(this.recipes);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        data.readStreamables(this.recipes, Recipe.class);
    }

    static {
        memoryBlacklist.add(ItemMap.class);
    }

    public static final class Recipe
    implements INBTTagable,
    IStreamable {
        private InventoryAdapter matrix;
        private long lastUsed;
        private boolean locked;
        private ItemStack cachedRecipeOutput;

        public Recipe() {
        }

        public Recipe(InventoryCrafting crafting) {
            this.matrix = new InventoryAdapter(new InventoryPlain((IInventory)crafting));
        }

        public Recipe(NBTTagCompound nbttagcompound) {
            this.readFromNBT(nbttagcompound);
        }

        public void updateLastUse(long lastUsed) {
            this.lastUsed = lastUsed;
        }

        public void toggleLock() {
            this.locked = !this.locked;
        }

        public InventoryAdapter getMatrix() {
            return this.matrix;
        }

        public ItemStack getRecipeOutput(World world) {
            if (this.cachedRecipeOutput == null) {
                InventoryCrafting crafting = new InventoryCrafting(DUMMY_CONTAINER, 3, 3);
                for (int i = 0; i < crafting.getSizeInventory(); ++i) {
                    crafting.setInventorySlotContents(i, this.matrix.getStackInSlot(i));
                }
                this.cachedRecipeOutput = CraftingManager.getInstance().findMatchingRecipe(crafting, world);
            }
            return this.cachedRecipeOutput;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean hasSameOutput(InventoryCrafting crafting, World world) {
            ItemStack recipeOutput = this.getRecipeOutput(world);
            if (recipeOutput == null) {
                return false;
            }
            ItemStack matchingRecipeOutput = CraftingManager.getInstance().findMatchingRecipe(crafting, world);
            return ItemStack.areItemStacksEqual((ItemStack)recipeOutput, (ItemStack)matchingRecipeOutput);
        }

        @Override
        public final void readFromNBT(NBTTagCompound nbttagcompound) {
            this.matrix = new InventoryAdapter((IInventory)new InventoryCrafting(DUMMY_CONTAINER, 3, 3));
            this.matrix.readFromNBT(nbttagcompound);
            this.sanitizeMatrix();
            this.lastUsed = nbttagcompound.getLong("LastUsed");
            this.locked = nbttagcompound.getBoolean("Locked");
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            this.sanitizeMatrix();
            this.matrix.writeToNBT(nbttagcompound);
            nbttagcompound.setLong("LastUsed", this.lastUsed);
            nbttagcompound.setBoolean("Locked", this.locked);
        }

        @Override
        public void writeData(DataOutputStreamForestry data) throws IOException {
            this.sanitizeMatrix();
            this.matrix.writeData(data);
            data.writeLong(this.lastUsed);
            data.writeBoolean(this.locked);
        }

        @Override
        public void readData(DataInputStreamForestry data) throws IOException {
            this.matrix = new InventoryAdapter((IInventory)new InventoryCrafting(DUMMY_CONTAINER, 3, 3));
            this.matrix.readData(data);
            this.sanitizeMatrix();
            this.lastUsed = data.readLong();
            this.locked = data.readBoolean();
        }

        private void sanitizeMatrix() {
            for (int slot = 0; slot < this.matrix.getSizeInventory(); ++slot) {
                ItemStack stack = this.matrix.getStackInSlot(slot);
                if (stack == null) continue;
                stack.stackSize = 1;
            }
        }
    }
}

