/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.gui.slots.SlotForestry;
import forestry.core.render.TextureManager;
import forestry.core.tiles.ICrafter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class SlotWatched
extends SlotForestry {
    private ICrafter crafter;
    private String blockedTexture = "slots/blocked";

    protected SlotWatched(IInventory inventory, int slotIndex, int xPos, int yPos) {
        super(inventory, slotIndex, xPos, yPos);
    }

    public SlotWatched setCrafter(ICrafter crafter) {
        this.crafter = crafter;
        return this;
    }

    public void onPickupFromSlot(EntityPlayer player, ItemStack itemStack) {
        if (this.crafter != null) {
            this.crafter.takenFromSlot(this.getSlotIndex(), player);
        }
    }

    public SlotWatched setBlockedTexture(String ident) {
        this.blockedTexture = ident;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getBackgroundIconIndex() {
        ItemStack stack = this.getStack();
        if (!this.isItemValid(stack)) {
            return TextureManager.getInstance().getDefault(this.blockedTexture);
        }
        return null;
    }
}

