/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.network;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketServer;
import forestry.core.network.IPacketId;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketIdServer;
import forestry.mail.tiles.TileTrader;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketTraderAddressRequest
extends PacketCoordinates
implements IForestryPacketServer {
    private String addressName;

    public PacketTraderAddressRequest() {
    }

    public PacketTraderAddressRequest(TileTrader tile, String addressName) {
        super((IPacketId)PacketIdServer.TRADING_ADDRESS_REQUEST, tile);
        this.addressName = addressName;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeUTF(this.addressName);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.addressName = data.readUTF();
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayerMP player) throws IOException {
        TileEntity tile = this.getTarget(player.worldObj);
        if (tile instanceof TileTrader) {
            ((TileTrader)tile).handleSetAddressRequest(this.addressName);
        }
    }
}

