/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.tiles;

import forestry.api.circuits.ICircuitSocketType;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.farming.IFarmComponent;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.circuits.ISocketable;
import forestry.core.config.Config;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.network.IStreamableGui;
import forestry.farming.multiblock.FakeFarmController;
import forestry.farming.multiblock.FarmController;
import forestry.farming.multiblock.IFarmController;
import forestry.farming.render.EnumFarmBlockTexture;
import forestry.farming.tiles.TileFarmPlain;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public abstract class TileFarm
extends RectangularMultiblockTileEntityBase
implements IFarmComponent,
IHintSource,
ISocketable,
IStreamableGui,
IErrorLogicSource,
IRestrictedAccess {
    public static final int TYPE_PLAIN = 0;
    public static final int TYPE_REVERSE = 1;
    public static final int TYPE_TOP = 2;
    public static final int TYPE_BAND = 3;
    public static final int TYPE_GEARS = 4;
    public static final int TYPE_HATCH = 5;
    public static final int TYPE_VALVE = 6;
    public static final int TYPE_CONTROL = 7;
    private EnumFarmBlockTexture farmBlockTexture = EnumFarmBlockTexture.BRICK_STONE;

    @Override
    public void openGui(EntityPlayer player) {
        if (this.isConnected()) {
            player.openGui(ForestryAPI.instance, GuiId.MultiFarmGUI.ordinal(), this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        super.onMachineAssembled(controller);
        this.notifyNeighborsOfBlockChange();
        this.markDirty();
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        this.notifyNeighborsOfBlockChange();
        this.markDirty();
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        return this.getFarmController().getInternalInventory();
    }

    @Override
    public boolean allowsAutomation() {
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.farmBlockTexture = EnumFarmBlockTexture.getFromCompound(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.farmBlockTexture.saveToCompound(nbttagcompound);
    }

    public void setFarmBlockTexture(EnumFarmBlockTexture farmBlockTexture) {
        if (this.farmBlockTexture != farmBlockTexture) {
            this.farmBlockTexture = farmBlockTexture;
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public EnumFarmBlockTexture getFarmBlockTexture() {
        return this.farmBlockTexture;
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        this.farmBlockTexture.saveToCompound(packetData);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        EnumFarmBlockTexture farmBlockTexture = EnumFarmBlockTexture.getFromCompound(packetData);
        this.setFarmBlockTexture(farmBlockTexture);
    }

    @Override
    public void onMachineActivated() {
    }

    @Override
    public void onMachineDeactivated() {
    }

    @Override
    public MultiblockControllerBase createNewMultiblock() {
        return new FarmController(this.worldObj);
    }

    @Override
    public Class<? extends MultiblockControllerBase> getMultiblockControllerType() {
        return FarmController.class;
    }

    public IFarmController getFarmController() {
        if (this.isConnected()) {
            return (IFarmController)((Object)super.getMultiblockController());
        }
        return FakeFarmController.instance;
    }

    @Override
    public void isGoodForExteriorLevel(int level) throws MultiblockValidationException {
        if (level == 2 && !(this instanceof TileFarmPlain)) {
            throw new MultiblockValidationException(StatCollector.translateToLocal((String)"for.multiblock.farm.error.needPlainBand"));
        }
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        if (!(this instanceof TileFarmPlain)) {
            throw new MultiblockValidationException(StatCollector.translateToLocal((String)"for.multiblock.farm.error.needPlainInterior"));
        }
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"farm");
    }

    @Override
    public int getSocketCount() {
        return this.getFarmController().getSocketCount();
    }

    @Override
    public ItemStack getSocket(int slot) {
        return this.getFarmController().getSocket(slot);
    }

    @Override
    public void setSocket(int slot, ItemStack stack) {
        this.getFarmController().setSocket(slot, stack);
    }

    @Override
    public ICircuitSocketType getSocketType() {
        return this.getFarmController().getSocketType();
    }

    @Override
    public void writeGuiData(DataOutputStreamForestry data) throws IOException {
        this.getFarmController().writeGuiData(data);
    }

    @Override
    public void readGuiData(DataInputStreamForestry data) throws IOException {
        this.getFarmController().readGuiData(data);
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.getFarmController().getErrorLogic();
    }

    @Override
    public IAccessHandler getAccessHandler() {
        return this.getFarmController().getAccessHandler();
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        this.getFarmController().onSwitchAccess(oldAccess, newAccess);
    }
}

