/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.tiles.IFilterSlotDelegate;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class ItemInventory
implements IInventory,
IFilterSlotDelegate {
    private static final String KEY_ITEMS = "Items";
    private static final String KEY_SLOTS = "Slots";
    private static final String KEY_UID = "UID";
    private static final Random rand = new Random();
    private final EntityPlayer player;
    private final ItemStack parent;
    private final ItemStack[] inventoryStacks;

    public ItemInventory(EntityPlayer player, int size, ItemStack parent) {
        this.player = player;
        this.parent = parent;
        this.inventoryStacks = new ItemStack[size];
        this.setUID();
        this.readFromNBT(parent.getTagCompound());
    }

    public static int getOccupiedSlotCount(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.getTagCompound();
        if (nbt == null) {
            return 0;
        }
        if (nbt.hasKey(KEY_SLOTS)) {
            NBTTagCompound slotNbt = nbt.getCompoundTag(KEY_SLOTS);
            return slotNbt.func_150296_c().size();
        }
        int count = 0;
        if (nbt.hasKey(KEY_ITEMS)) {
            NBTTagList nbttaglist = nbt.getTagList(KEY_ITEMS, 10);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
                ItemStack itemStack1 = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound1);
                if (itemStack1 == null || itemStack1.stackSize <= 0) continue;
                ++count;
            }
        }
        return count;
    }

    private void setUID() {
        NBTTagCompound nbt;
        ItemStack parent = this.getParent();
        if (parent.getTagCompound() == null) {
            parent.setTagCompound(new NBTTagCompound());
        }
        if (!(nbt = parent.getTagCompound()).hasKey(KEY_UID)) {
            nbt.setInteger(KEY_UID, rand.nextInt());
        }
    }

    public boolean isParentItemInventory(ItemStack itemStack) {
        ItemStack parent = this.getParent();
        return ItemInventory.isSameItemInventory(parent, itemStack);
    }

    protected ItemStack getParent() {
        ItemStack equipped = this.player.getCurrentEquippedItem();
        if (ItemInventory.isSameItemInventory(equipped, this.parent)) {
            return equipped;
        }
        return this.parent;
    }

    private static boolean isSameItemInventory(ItemStack base, ItemStack comparison) {
        if (base == null || comparison == null) {
            return false;
        }
        if (base.getItem() != comparison.getItem()) {
            return false;
        }
        if (!base.hasTagCompound() || !comparison.hasTagCompound()) {
            return false;
        }
        String baseUID = base.getTagCompound().getString(KEY_UID);
        String comparisonUID = comparison.getTagCompound().getString(KEY_UID);
        return baseUID != null && comparisonUID != null && baseUID.equals(comparisonUID);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        if (nbt.hasKey(KEY_SLOTS)) {
            NBTTagCompound nbtSlots = nbt.getCompoundTag(KEY_SLOTS);
            for (int i = 0; i < this.inventoryStacks.length; ++i) {
                String slotKey = ItemInventory.getSlotNBTKey(i);
                if (nbtSlots.hasKey(slotKey)) {
                    ItemStack itemStack;
                    NBTTagCompound itemNbt = nbtSlots.getCompoundTag(slotKey);
                    this.inventoryStacks[i] = itemStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)itemNbt);
                    continue;
                }
                this.inventoryStacks[i] = null;
            }
        } else if (nbt.hasKey(KEY_ITEMS)) {
            for (int i = 0; i < this.inventoryStacks.length; ++i) {
                this.inventoryStacks[i] = null;
            }
            NBTTagList nbttaglist = nbt.getTagList(KEY_ITEMS, 10);
            for (int i = 0; i < nbttaglist.tagCount(); ++i) {
                ItemStack itemStack;
                NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
                byte byte0 = nbttagcompound1.getByte("Slot");
                if (byte0 < 0 || byte0 >= this.inventoryStacks.length) continue;
                this.inventoryStacks[byte0] = itemStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)nbttagcompound1);
            }
            this.writeToParentNBT();
        }
    }

    private void writeToParentNBT() {
        ItemStack parent = this.getParent();
        if (parent == null) {
            return;
        }
        NBTTagCompound nbt = parent.getTagCompound();
        NBTTagCompound slotsNbt = new NBTTagCompound();
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack itemStack = this.getStackInSlot(i);
            if (itemStack == null) continue;
            String slotKey = ItemInventory.getSlotNBTKey(i);
            NBTTagCompound itemNbt = new NBTTagCompound();
            itemStack.writeToNBT(itemNbt);
            slotsNbt.setTag(slotKey, (NBTBase)itemNbt);
        }
        nbt.setTag(KEY_SLOTS, (NBTBase)slotsNbt);
        nbt.removeTag(KEY_ITEMS);
    }

    private static String getSlotNBTKey(int i) {
        return Integer.toString(i, 36);
    }

    public void onSlotClick(EntityPlayer player) {
    }

    public ItemStack decrStackSize(int i, int j) {
        ItemStack stack = this.getStackInSlot(i);
        if (stack == null) {
            return null;
        }
        if (stack.stackSize <= j) {
            this.setInventorySlotContents(i, null);
            return stack;
        }
        ItemStack product = stack.splitStack(j);
        this.setInventorySlotContents(i, stack);
        return product;
    }

    public void setInventorySlotContents(int i, ItemStack itemstack) {
        NBTTagCompound slotNbt;
        if (itemstack != null && itemstack.stackSize == 0) {
            itemstack = null;
        }
        this.inventoryStacks[i] = itemstack;
        ItemStack parent = this.getParent();
        NBTTagCompound nbt = parent.getTagCompound();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            parent.setTagCompound(nbt);
        }
        if (!nbt.hasKey(KEY_SLOTS)) {
            slotNbt = new NBTTagCompound();
            nbt.setTag(KEY_SLOTS, (NBTBase)slotNbt);
        } else {
            slotNbt = nbt.getCompoundTag(KEY_SLOTS);
        }
        String slotKey = ItemInventory.getSlotNBTKey(i);
        if (itemstack == null) {
            slotNbt.removeTag(slotKey);
        } else {
            NBTTagCompound itemNbt = new NBTTagCompound();
            itemstack.writeToNBT(itemNbt);
            slotNbt.setTag(slotKey, (NBTBase)itemNbt);
        }
    }

    public ItemStack getStackInSlot(int i) {
        return this.inventoryStacks[i];
    }

    public int getSizeInventory() {
        return this.inventoryStacks.length;
    }

    public String getInventoryName() {
        return "BeeBag";
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public final void markDirty() {
        this.writeToParentNBT();
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return this.canSlotAccept(slotIndex, itemStack);
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        ItemStack toReturn = this.getStackInSlot(slot);
        if (toReturn != null) {
            this.setInventorySlotContents(slot, null);
        }
        return toReturn;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return false;
    }
}

