/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.IBee;
import forestry.apiculture.network.PacketHabitatBiomePointer;
import forestry.core.proxy.Proxies;
import forestry.core.utils.vect.Vect;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class HabitatLocatorLogic {
    private static final int maxChecksPerTick = 100;
    private static final int maxSearchRadiusIterations = 500;
    private static final int spacing = 20;
    private static final Set<BiomeGenBase> waterBiomes = new HashSet<BiomeGenBase>();
    private static final Set<BiomeGenBase> netherBiomes = new HashSet<BiomeGenBase>();
    private static final Set<BiomeGenBase> endBiomes = new HashSet<BiomeGenBase>();
    private Set<BiomeGenBase> targetBiomes = new HashSet<BiomeGenBase>();
    private boolean biomeFound = false;
    private int searchRadiusIteration = 0;
    private int searchAngleIteration = 0;
    private Vect searchCenter;

    public boolean isBiomeFound() {
        return this.biomeFound;
    }

    public Set<BiomeGenBase> getTargetBiomes() {
        return this.targetBiomes;
    }

    public void startBiomeSearch(IBee bee, EntityPlayer player) {
        this.targetBiomes = new HashSet<BiomeGenBase>(bee.getSuitableBiomes());
        this.searchAngleIteration = 0;
        this.searchRadiusIteration = 0;
        this.biomeFound = false;
        this.searchCenter = new Vect((Entity)player);
        BiomeGenBase currentBiome = player.worldObj.getBiomeGenForCoords(this.searchCenter.x, this.searchCenter.z);
        HabitatLocatorLogic.removeInvalidBiomes(currentBiome, this.targetBiomes);
        Proxies.render.setHabitatLocatorTexture(null, null);
    }

    public void onUpdate(World world, Entity player) {
        if (world.isRemote) {
            return;
        }
        if (this.targetBiomes.isEmpty()) {
            return;
        }
        if (this.biomeFound && world.getTotalWorldTime() % 20L != 0L) {
            return;
        }
        ChunkCoordinates target = this.findNearestBiome(player, this.targetBiomes);
        if (target != null && player instanceof EntityPlayerMP) {
            Proxies.net.sendToPlayer(new PacketHabitatBiomePointer(target), (EntityPlayer)((EntityPlayerMP)player));
            this.biomeFound = true;
        }
    }

    private ChunkCoordinates findNearestBiome(Entity player, Collection<BiomeGenBase> biomesToSearch) {
        Vect playerPos = new Vect(player);
        ChunkCoordinates coordinates = HabitatLocatorLogic.getChunkCoordinates(playerPos, player.worldObj, biomesToSearch);
        if (coordinates != null) {
            this.searchAngleIteration = 0;
            this.searchRadiusIteration = 0;
            return new ChunkCoordinates(playerPos.x, playerPos.y, playerPos.z);
        }
        int radius = 20 * (this.searchRadiusIteration + 1);
        double angleSpacing = 2.0 * Math.asin(20.0 / (2.0 * (double)radius));
        angleSpacing = Math.PI * 2 / (double)Math.round(Math.PI * 2 / angleSpacing);
        for (int i = 0; i < 100; ++i) {
            int zOffset;
            double angle = angleSpacing * (double)this.searchAngleIteration;
            if (angle > Math.PI * 2) {
                this.searchAngleIteration = 0;
                ++this.searchRadiusIteration;
                if (this.searchRadiusIteration > 500) {
                    this.searchAngleIteration = 0;
                    this.searchRadiusIteration = 0;
                    this.searchCenter = playerPos;
                }
                return null;
            }
            ++this.searchAngleIteration;
            int xOffset = Math.round((float)((double)radius * Math.cos(angle)));
            Vect pos = this.searchCenter.add(xOffset, 0, zOffset = Math.round((float)((double)radius * Math.sin(angle))));
            coordinates = HabitatLocatorLogic.getChunkCoordinates(pos, player.worldObj, biomesToSearch);
            if (coordinates == null) continue;
            this.searchAngleIteration = 0;
            this.searchRadiusIteration = 0;
            return coordinates;
        }
        return null;
    }

    private static ChunkCoordinates getChunkCoordinates(Vect pos, World world, Collection<BiomeGenBase> biomesToSearch) {
        int minBiomeRadius = 8;
        BiomeGenBase biome = world.getBiomeGenForCoords(pos.x, pos.z);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.getBiomeGenForCoords(pos.x - 8, pos.z);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.getBiomeGenForCoords(pos.x + 8, pos.z);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.getBiomeGenForCoords(pos.x, pos.z - 8);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        biome = world.getBiomeGenForCoords(pos.x, pos.z + 8);
        if (!biomesToSearch.contains(biome)) {
            return null;
        }
        return new ChunkCoordinates(pos.x, pos.y, pos.z);
    }

    private static void removeInvalidBiomes(BiomeGenBase currentBiome, Set<BiomeGenBase> biomesToSearch) {
        biomesToSearch.removeAll(waterBiomes);
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            biomesToSearch.retainAll(netherBiomes);
        } else {
            biomesToSearch.removeAll(netherBiomes);
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)currentBiome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            biomesToSearch.retainAll(endBiomes);
        } else {
            biomesToSearch.removeAll(endBiomes);
        }
    }

    static {
        Collections.addAll(waterBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.BEACH));
        Collections.addAll(waterBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN));
        Collections.addAll(waterBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.RIVER));
        Collections.addAll(netherBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
        Collections.addAll(endBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.END));
    }
}

