/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitSocketType;
import forestry.api.farming.FarmDirection;
import forestry.core.circuits.CircuitRecipe;
import forestry.core.circuits.ContainerSolderingIron;
import forestry.core.circuits.SolderManager;
import forestry.core.gui.GuiForestry;
import forestry.core.inventory.ItemInventorySolderingIron;
import forestry.core.utils.StringUtil;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GuiSolderingIron
extends GuiForestry<ContainerSolderingIron, ItemInventorySolderingIron> {
    public GuiSolderingIron(EntityPlayer player, ItemInventorySolderingIron inventory) {
        super("textures/gui/solder.png", new ContainerSolderingIron(player, inventory), inventory);
        this.xSize = 176;
        this.ySize = 205;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float var1, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(var1, mouseX, mouseY);
        ICircuitLayout layout = ((ContainerSolderingIron)this.inventorySlots).getLayout();
        String title = layout.getName();
        this.fontRendererObj.drawString(title, this.guiLeft + 8 + this.getCenteredOffset(title, 138), this.guiTop + 16, this.fontColor.get("gui.screen"));
        for (int i = 0; i < 4; ++i) {
            ItemStack tube = ((ItemInventorySolderingIron)this.inventory).getStackInSlot(i + 2);
            CircuitRecipe recipe = SolderManager.getMatchingRecipe(layout, tube);
            String description = recipe == null ? "(" + StringUtil.localize("gui.noeffect") + ")" : StringUtil.localize(recipe.getCircuit().getName()) + " (" + recipe.getCircuit().getLimit() + ")";
            int row = i * 20;
            this.fontRendererObj.drawString(description, this.guiLeft + 32, this.guiTop + 36 + row, this.fontColor.get("gui.screen"));
            if (tube != null) continue;
            try {
                ICircuitSocketType socketType = layout.getSocketType();
                if (!CircuitSocketType.FARM.equals(socketType)) continue;
                FarmDirection farmDirection = FarmDirection.values()[i];
                String farmDirectionString = farmDirection.toString().toLowerCase(Locale.ENGLISH);
                String localizedDirection = StringUtil.localize("gui.solder." + farmDirectionString);
                this.fontRendererObj.drawString(localizedDirection, this.guiLeft + 17, this.guiTop + 36 + row, this.fontColor.get("gui.screen"));
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.add(new GuiButton(1, this.guiLeft + 12, this.guiTop + 10, 12, 18, "<"));
        this.buttonList.add(new GuiButton(2, this.guiLeft + 130, this.guiTop + 10, 12, 18, ">"));
    }

    protected void actionPerformed(GuiButton guibutton) {
        super.actionPerformed(guibutton);
        if (guibutton.id == 1) {
            ContainerSolderingIron.regressSelection(0);
        } else if (guibutton.id == 2) {
            ContainerSolderingIron.advanceSelection(0);
        }
    }
}

