/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorLogic;
import forestry.apiculture.multiblock.AlvearyController;
import forestry.apiculture.multiblock.FakeAlvearyController;
import forestry.apiculture.multiblock.IAlvearyController;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.rectangular.RectangularMultiblockTileEntityBase;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class TileAlveary
extends RectangularMultiblockTileEntityBase
implements IBeeHousing,
IRestrictedAccess {
    public static final int PLAIN_META = 0;
    public static final int ENTRANCE_META = 1;
    public static final int SWARMER_META = 2;
    public static final int FAN_META = 3;
    public static final int HEATER_META = 4;
    public static final int HYGRO_META = 5;
    public static final int STABILIZER_META = 6;
    public static final int SIEVE_META = 7;

    public int getIcon(int side) {
        return 0;
    }

    @Override
    public void isGoodForExteriorLevel(int level) throws MultiblockValidationException {
        if (level == 2 && !(this instanceof TileAlvearyPlain)) {
            throw new MultiblockValidationException(StatCollector.translateToLocal((String)"for.multiblock.alveary.error.needPlainOnTop"));
        }
    }

    @Override
    public void isGoodForInterior() throws MultiblockValidationException {
        if (!(this instanceof TileAlvearyPlain)) {
            throw new MultiblockValidationException(StatCollector.translateToLocal((String)"for.multiblock.alveary.error.needPlainInterior"));
        }
    }

    @Override
    public void onMachineActivated() {
    }

    @Override
    public void onMachineDeactivated() {
    }

    @Override
    public MultiblockControllerBase createNewMultiblock() {
        return new AlvearyController(this.worldObj);
    }

    @Override
    public Class<? extends MultiblockControllerBase> getMultiblockControllerType() {
        return AlvearyController.class;
    }

    public IAlvearyController getAlvearyController() {
        if (this.isConnected()) {
            return (IAlvearyController)((Object)this.getMultiblockController());
        }
        return FakeAlvearyController.instance;
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        super.onMachineAssembled(controller);
        if (this.worldObj.isRemote) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
        this.notifyNeighborsOfBlockChange();
        this.markDirty();
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        if (this.worldObj.isRemote) {
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        }
        this.notifyNeighborsOfBlockChange();
        this.markDirty();
    }

    @Override
    public BiomeGenBase getBiome() {
        return this.getAlvearyController().getBiome();
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return this.getAlvearyController().getBeeModifiers();
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return this.getAlvearyController().getBeeListeners();
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.getAlvearyController().getBeeInventory();
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.getAlvearyController().getBeekeepingLogic();
    }

    @Override
    public Vec3 getBeeFXCoordinates() {
        return this.getAlvearyController().getBeeFXCoordinates();
    }

    @Override
    public EnumTemperature getTemperature() {
        return this.getAlvearyController().getTemperature();
    }

    @Override
    public EnumHumidity getHumidity() {
        return this.getAlvearyController().getHumidity();
    }

    @Override
    public int getBlockLightValue() {
        return this.getAlvearyController().getBlockLightValue();
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return this.getAlvearyController().canBlockSeeTheSky();
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.getAlvearyController().getErrorLogic();
    }

    @Override
    public IAccessHandler getAccessHandler() {
        return this.getAlvearyController().getAccessHandler();
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        this.getAlvearyController().onSwitchAccess(oldAccess, newAccess);
    }
}

