/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.apiculture.entities.EntityMinecartApiary;
import forestry.apiculture.entities.EntityMinecartBeeHousingBase;
import forestry.apiculture.entities.EntityMinecartBeehouse;
import forestry.core.render.TextureManager;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemMinecartBeehouse
extends ItemMinecart {
    private final String[] definition = new String[]{"cart.beehouse", "cart.apiary"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemMinecartBeehouse() {
        super(0);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        BlockDispenser.dispenseBehaviorRegistry.putObject((Object)this, null);
    }

    public boolean onItemUse(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int side, float facingX, float facingY, float facingZ) {
        if (!BlockRailBase.func_150051_a((Block)world.getBlock(x, y, z))) {
            return false;
        }
        if (!world.isRemote) {
            EntityMinecartBeeHousingBase entityMinecart = itemStack.getItemDamage() == 0 ? new EntityMinecartBeehouse(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f) : new EntityMinecartApiary(world, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
            entityMinecart.setOwner(player.getGameProfile());
            if (itemStack.hasDisplayName()) {
                entityMinecart.setMinecartName(itemStack.getDisplayName());
            }
            world.spawnEntityInWorld((Entity)entityMinecart);
        }
        --itemStack.stackSize;
        return true;
    }

    public String getUnlocalizedName(ItemStack stack) {
        if (stack.getItemDamage() >= this.definition.length || stack.getItemDamage() < 0) {
            return "item.forestry.unknown";
        }
        return "item.for." + this.definition[stack.getItemDamage()];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new IIcon[this.definition.length];
        for (int i = 0; i < this.definition.length; ++i) {
            this.icons[i] = TextureManager.registerTex(register, this.definition[i]);
        }
    }

    public IIcon getIconFromDamage(int damage) {
        if (damage >= this.definition.length || damage < 0) {
            return this.icons[0];
        }
        return this.icons[damage];
    }

    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < this.definition.length; ++i) {
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }
}

