/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.items.ItemForestry;
import forestry.core.render.TextureManager;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public class ItemMisc
extends ItemForestry {
    private final String[] definition = new String[]{"pulsatingDust", "pulsatingMesh", "silkWisp", "wovenSilk", "dissipationCharge", "iceShard", "scentedPaneling"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemMisc() {
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    public boolean isDamageable() {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public String getUnlocalizedName(ItemStack stack) {
        if (stack.getItemDamage() >= this.definition.length || stack.getItemDamage() < 0) {
            return "item.forestry.unknown";
        }
        return super.getUnlocalizedName(stack) + "." + this.definition[stack.getItemDamage()];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new IIcon[this.definition.length];
        for (int i = 0; i < this.definition.length; ++i) {
            this.icons[i] = TextureManager.registerTex(register, this.definition[i]);
        }
    }

    public IIcon getIconFromDamage(int damage) {
        if (damage >= this.definition.length || damage < 0) {
            return this.icons[0];
        }
        return this.icons[damage];
    }

    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        for (int i = 0; i < 7; ++i) {
            itemList.add(new ItemStack((Item)this, 1, i));
        }
    }
}

