/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.alleles;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpeciesCustom;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.alleles.Allele;
import forestry.core.utils.ItemStackUtil;
import java.util.Collection;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public abstract class AlleleSpecies
extends Allele
implements IAlleleSpeciesCustom {
    private final String binomial;
    private final String authority;
    private final String description;
    private final IClassification branch;
    private boolean hasEffect = false;
    private boolean isSecret = false;
    private boolean isCounted = true;
    private EnumTemperature climate = EnumTemperature.NORMAL;
    private EnumHumidity humidity = EnumHumidity.NORMAL;

    protected AlleleSpecies(String uid, String unlocalizedName, String authority, String unlocalizedDescription, boolean isDominant, IClassification branch, String binomial) {
        super(uid, unlocalizedName, isDominant);
        this.branch = branch;
        this.binomial = binomial;
        this.description = StatCollector.translateToLocal((String)unlocalizedDescription);
        this.authority = authority;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public float getResearchSuitability(ItemStack itemstack) {
        if (itemstack == null) {
            return 0.0f;
        }
        if (ForestryItem.honeyDrop.isItemEqual(itemstack)) {
            return 0.5f;
        }
        if (ForestryItem.honeydew.isItemEqual(itemstack)) {
            return 0.7f;
        }
        if (ForestryItem.beeComb.isItemEqual(itemstack)) {
            return 0.4f;
        }
        if (this.getRoot().isMember(itemstack)) {
            return 1.0f;
        }
        for (Map.Entry<ItemStack, Float> entry : this.getRoot().getResearchCatalysts().entrySet()) {
            if (!ItemStackUtil.isIdenticalItem(entry.getKey(), itemstack)) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }

    @Override
    public ItemStack[] getResearchBounty(World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
        Collection<? extends IMutation> combinations;
        ItemStack research = null;
        if (world.rand.nextFloat() < 10.0f / (float)bountyLevel && (combinations = this.getRoot().getCombinations(this)).size() > 0) {
            IMutation[] candidates = combinations.toArray(new IMutation[combinations.size()]);
            research = AlleleManager.alleleRegistry.getMutationNoteStack(researcher, candidates[world.rand.nextInt(candidates.length)]);
        }
        if (research != null) {
            return new ItemStack[]{research};
        }
        return ItemStackUtil.EMPTY_STACK_ARRAY;
    }

    @Override
    public EnumTemperature getTemperature() {
        return this.climate;
    }

    @Override
    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    @Override
    public boolean hasEffect() {
        return this.hasEffect;
    }

    @Override
    public boolean isSecret() {
        return this.isSecret;
    }

    @Override
    public boolean isCounted() {
        return this.isCounted;
    }

    @Override
    public String getBinomial() {
        return this.binomial;
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public IClassification getBranch() {
        return this.branch;
    }

    @Override
    public IAlleleSpeciesCustom setTemperature(EnumTemperature temperature) {
        this.climate = temperature;
        return this;
    }

    @Override
    public IAlleleSpeciesCustom setHumidity(EnumHumidity humidity) {
        this.humidity = humidity;
        return this;
    }

    @Override
    public IAlleleSpeciesCustom setHasEffect() {
        this.hasEffect = true;
        return this;
    }

    @Override
    public IAlleleSpeciesCustom setIsSecret() {
        this.isSecret = true;
        return this;
    }

    @Override
    public IAlleleSpeciesCustom setIsNotCounted() {
        this.isCounted = false;
        return this;
    }

    @Deprecated
    public <T extends AlleleSpecies> T setTemperatureDeprecated(EnumTemperature temperature) {
        this.climate = temperature;
        return (T)this;
    }

    @Deprecated
    public <T extends AlleleSpecies> T setHumidityDeprecated(EnumHumidity humidity) {
        this.humidity = humidity;
        return (T)this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract IIconProvider getIconProvider();
}

