/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.core.commands.CommandHelpers;
import forestry.core.commands.ICommandModeHelper;
import forestry.core.commands.IStatsSaveHelper;
import forestry.core.commands.SubCommand;
import forestry.core.config.Version;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public final class CommandSaveStats
extends SubCommand {
    private static final String discoveredSymbol = StatCollector.translateToLocal((String)"for.chat.command.forestry.stats.save.key.discovered.symbol");
    private static final String blacklistedSymbol = StatCollector.translateToLocal((String)"for.chat.command.forestry.stats.save.key.blacklisted.symbol");
    private static final String notCountedSymbol = StatCollector.translateToLocal((String)"for.chat.command.forestry.stats.save.key.notCounted.symbol");
    private final IStatsSaveHelper saveHelper;
    private final ICommandModeHelper modeHelper;

    public CommandSaveStats(IStatsSaveHelper saveHelper, ICommandModeHelper modeHelper) {
        super("save");
        this.saveHelper = saveHelper;
        this.modeHelper = modeHelper;
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] parameters) {
        return CommandHelpers.getListOfStringsMatchingLastWord(parameters, CommandHelpers.getPlayers());
    }

    @Override
    public void processSubCommand(ICommandSender sender, String[] args) {
        if (args.length > 1) {
            this.printHelp(sender);
            return;
        }
        String newLine = System.getProperty("line.separator");
        World world = CommandHelpers.getWorld(sender, this);
        EntityPlayerMP player = args.length > 0 ? CommandHelpers.getPlayer(sender, args[0]) : CommandHelpers.getPlayer(sender, sender.getCommandSenderName());
        ArrayList<String> statistics = new ArrayList<String>();
        String date = DateFormat.getInstance().format(new Date());
        statistics.add(StatCollector.translateToLocalFormatted((String)this.saveHelper.getUnlocalizedSaveStatsString(), (Object[])new Object[]{player.getDisplayName(), date}));
        statistics.add("");
        statistics.add(StatCollector.translateToLocalFormatted((String)"for.chat.command.forestry.stats.save.mode", (Object[])new Object[]{this.modeHelper.getModeName(world)}));
        statistics.add("");
        IBreedingTracker tracker = this.saveHelper.getBreedingTracker(world, player.getGameProfile());
        if (tracker == null) {
            statistics.add(StatCollector.translateToLocal((String)"for.chat.command.forestry.stats.save.error4"));
        } else {
            this.saveHelper.addExtraInfo(statistics, tracker);
            Collection<IAlleleSpecies> species = this.saveHelper.getSpecies();
            String speciesCount = StatCollector.translateToLocal((String)"for.gui.speciescount");
            String speciesCountLine = String.format("%s (%s):", speciesCount, species.size());
            statistics.add(speciesCountLine);
            statistics.add(StringUtil.line(speciesCountLine.length()));
            statistics.add(discoveredSymbol + ": " + StatCollector.translateToLocal((String)"for.chat.command.forestry.stats.save.key.discovered"));
            statistics.add(blacklistedSymbol + ": " + StatCollector.translateToLocal((String)"for.chat.command.forestry.stats.save.key.blacklisted"));
            statistics.add(notCountedSymbol + ": " + StatCollector.translateToLocal((String)"for.chat.command.forestry.stats.save.key.notCounted"));
            statistics.add("");
            String header = CommandSaveStats.generateSpeciesListHeader();
            statistics.add(header);
            statistics.add(StringUtil.line(header.length()));
            statistics.add("");
            for (IAlleleSpecies allele : species) {
                statistics.add(CommandSaveStats.generateSpeciesListEntry(allele, tracker));
            }
        }
        File file = new File(Proxies.common.getForestryRoot(), "config/" + "Forestry".toLowerCase(Locale.ENGLISH) + "/stats/" + player.getDisplayName() + '-' + this.saveHelper.getFileSuffix() + ".log");
        try {
            boolean success;
            File folder = file.getParentFile();
            if (folder != null && !folder.exists() && !(success = file.getParentFile().mkdirs())) {
                CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.stats.save.error1", new Object[0]);
                return;
            }
            if (!file.exists() && !file.createNewFile()) {
                CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.stats.save.error1", new Object[0]);
                return;
            }
            if (!file.canWrite()) {
                CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.stats.save.error2", new Object[0]);
                return;
            }
            FileOutputStream fileout = new FileOutputStream(file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileout, "UTF-8"));
            writer.write("# Forestry" + newLine + "# " + Version.getVersion() + newLine);
            for (String line : statistics) {
                writer.write(line + newLine);
            }
            writer.close();
        }
        catch (IOException ex) {
            CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.stats.save.error3", new Object[0]);
            ex.printStackTrace();
            return;
        }
        CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.stats.save.saved", player.getDisplayName());
    }

    private static String generateSpeciesListHeader() {
        String authority = StatCollector.translateToLocal((String)"for.gui.alyzer.authority");
        String species = StatCollector.translateToLocal((String)"for.gui.species");
        return CommandSaveStats.speciesListEntry(discoveredSymbol, blacklistedSymbol, notCountedSymbol, "UID", species, authority);
    }

    private static String generateSpeciesListEntry(IAlleleSpecies species, IBreedingTracker tracker) {
        String discovered = "";
        if (tracker.isDiscovered(species)) {
            discovered = discoveredSymbol;
        }
        String blacklisted = "";
        if (AlleleManager.alleleRegistry.isBlacklisted(species.getUID())) {
            blacklisted = blacklistedSymbol;
        }
        String notCounted = "";
        if (!species.isCounted()) {
            notCounted = notCountedSymbol;
        }
        return CommandSaveStats.speciesListEntry(discovered, blacklisted, notCounted, species.getUID(), species.getName(), species.getAuthority());
    }

    private static String speciesListEntry(String discovered, String blacklisted, String notCounted, String UID, String speciesName, String authority) {
        return String.format("[ %-2s ] [ %-2s ] [ %-2s ]\t%-40s %-20s %-20s", discovered, blacklisted, notCounted, UID, speciesName, authority);
    }
}

