/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.core.GuiHandlerBase;
import forestry.core.config.ForestryItem;
import forestry.core.network.GuiId;
import forestry.core.tiles.TileUtil;
import forestry.mail.gui.ContainerCatalogue;
import forestry.mail.gui.ContainerLetter;
import forestry.mail.gui.ContainerMailbox;
import forestry.mail.gui.ContainerPhilatelist;
import forestry.mail.gui.ContainerTradeName;
import forestry.mail.gui.ContainerTrader;
import forestry.mail.gui.GuiCatalogue;
import forestry.mail.gui.GuiLetter;
import forestry.mail.gui.GuiMailbox;
import forestry.mail.gui.GuiPhilatelist;
import forestry.mail.gui.GuiTradeName;
import forestry.mail.gui.GuiTrader;
import forestry.mail.inventory.ItemInventoryLetter;
import forestry.mail.items.ItemLetter;
import forestry.mail.tiles.TileMailbox;
import forestry.mail.tiles.TilePhilatelist;
import forestry.mail.tiles.TileTrader;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GuiHandlerMail
extends GuiHandlerBase {
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[id]) {
            case CatalogueGUI: {
                ItemStack cata = player.getCurrentEquippedItem();
                if (cata == null) {
                    return null;
                }
                if (ForestryItem.catalogue.isItemEqual(cata)) {
                    return new GuiCatalogue(player);
                }
                return null;
            }
            case LetterGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                if (equipped.getItem() instanceof ItemLetter) {
                    return new GuiLetter(player, new ItemInventoryLetter(player, equipped));
                }
                return null;
            }
            case MailboxGUI: {
                return new GuiMailbox(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileMailbox.class));
            }
            case PhilatelistGUI: {
                return new GuiPhilatelist(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TilePhilatelist.class));
            }
            case TraderGUI: {
                return new GuiTrader(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileTrader.class));
            }
            case TraderNameGUI: {
                return new GuiTradeName(TileUtil.getTile((IBlockAccess)world, x, y, z, TileTrader.class));
            }
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id >= GuiId.values().length) {
            return null;
        }
        switch (GuiId.values()[id]) {
            case CatalogueGUI: {
                ItemStack cata = player.getCurrentEquippedItem();
                if (cata == null) {
                    return null;
                }
                if (ForestryItem.catalogue.isItemEqual(cata)) {
                    return new ContainerCatalogue(player);
                }
                return null;
            }
            case LetterGUI: {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (equipped == null) {
                    return null;
                }
                if (equipped.getItem() instanceof ItemLetter) {
                    return new ContainerLetter(player, new ItemInventoryLetter(player, equipped));
                }
                return null;
            }
            case MailboxGUI: {
                return new ContainerMailbox(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileMailbox.class));
            }
            case PhilatelistGUI: {
                return new ContainerPhilatelist(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TilePhilatelist.class));
            }
            case TraderGUI: {
                return new ContainerTrader(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileTrader.class));
            }
            case TraderNameGUI: {
                return new ContainerTradeName(TileUtil.getTile((IBlockAccess)world, x, y, z, TileTrader.class));
            }
        }
        return null;
    }
}

