/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.inventory.InventoryAnalyzer;
import forestry.core.inventory.wrappers.IInvSlot;
import forestry.core.inventory.wrappers.InventoryIterator;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.network.PacketItemStackDisplay;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.InventoryUtil;
import forestry.plugins.PluginManager;
import java.io.IOException;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileAnalyzer
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
IFluidHandler,
IItemStackDisplay {
    private static final int TIME_TO_ANALYZE = 125;
    private static final int HONEY_REQUIRED = 100;
    private static final int ENERGY_PER_WORK_CYCLE = 20320;
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final IInventory invInput;
    private final IInventory invOutput;
    private IIndividual specimenToAnalyze;
    private ItemStack individualOnDisplayClient;

    public TileAnalyzer() {
        super(GuiId.AnalyzerGUI, "analyzer", 800, 5000);
        this.setInternalInventory(new InventoryAnalyzer(this));
        this.resourceTank = new FilteredTank(10000, Fluids.HONEY.getFluid());
        this.tankManager = new TankManager(this, this.resourceTank);
        this.invInput = new InventoryMapper((IInventory)this.getInternalInventory(), 2, 6);
        this.invOutput = new InventoryMapper((IInventory)this.getInternalInventory(), 8, 4);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        ItemStack stackToAnalyze = this.getStackInSlot(0);
        if (stackToAnalyze != null) {
            this.specimenToAnalyze = AlleleManager.alleleRegistry.getIndividual(stackToAnalyze);
        }
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 1);
        }
    }

    @Override
    public boolean workCycle() {
        boolean added;
        ItemStack stackToAnalyze = this.getStackInSlot(0);
        if (stackToAnalyze == null) {
            return false;
        }
        if (!this.specimenToAnalyze.isAnalyzed()) {
            if (!this.resourceTank.canDrain(100)) {
                return false;
            }
            this.resourceTank.drain(100, true);
            this.specimenToAnalyze.analyze();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.specimenToAnalyze.writeToNBT(nbttagcompound);
            stackToAnalyze.setTagCompound(nbttagcompound);
        }
        if (!(added = InventoryUtil.tryAddStack(this.invOutput, stackToAnalyze, true))) {
            return false;
        }
        this.setInventorySlotContents(0, null);
        PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
        Proxies.net.sendNetworkPacket(packet, this.worldObj);
        return true;
    }

    private IInvSlot getInputSlot() {
        for (IInvSlot slot : InventoryIterator.getIterable(this.invInput)) {
            ItemStack inputStack = slot.getStackInSlot();
            if (!AlleleManager.alleleRegistry.isIndividual(inputStack)) continue;
            return slot;
        }
        return null;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        ItemStack displayStack = this.getIndividualOnDisplay();
        data.writeItemStack(displayStack);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.individualOnDisplayClient = data.readItemStack();
        this.tankManager.readData(data);
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        if (!ItemStack.areItemStacksEqual((ItemStack)itemStack, (ItemStack)this.individualOnDisplayClient)) {
            this.individualOnDisplayClient = itemStack;
            this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public boolean hasWork() {
        this.moveSpecimenToAnalyzeSlot();
        ItemStack specimen = this.getStackInSlot(0);
        boolean hasSpecimen = specimen != null;
        boolean hasResource = true;
        boolean hasSpace = true;
        if (hasSpecimen) {
            hasSpace = InventoryUtil.tryAddStack(this.invOutput, specimen, true, false);
            if (!this.specimenToAnalyze.isAnalyzed()) {
                hasResource = this.resourceTank.canDrain(100);
            }
        }
        this.getErrorLogic().setCondition(!hasSpecimen, EnumErrorCode.NOTHINGANALYZE);
        this.getErrorLogic().setCondition(!hasResource, EnumErrorCode.NORESOURCE);
        this.getErrorLogic().setCondition(!hasSpace, EnumErrorCode.NOSPACE);
        return hasSpecimen && hasResource && hasSpace;
    }

    private void moveSpecimenToAnalyzeSlot() {
        ItemStack ersatz;
        if (this.getStackInSlot(0) != null) {
            return;
        }
        IInvSlot slot = this.getInputSlot();
        if (slot == null) {
            return;
        }
        ItemStack inputStack = slot.getStackInSlot();
        if (inputStack == null) {
            return;
        }
        if (PluginManager.Module.ARBORICULTURE.isEnabled() && !TreeManager.treeRoot.isMember(inputStack) && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(inputStack)) != null) {
            inputStack = ersatz;
        }
        this.specimenToAnalyze = AlleleManager.alleleRegistry.getIndividual(inputStack);
        if (this.specimenToAnalyze == null) {
            return;
        }
        this.setInventorySlotContents(0, inputStack);
        slot.setStackInSlot(null);
        if (this.specimenToAnalyze.isAnalyzed()) {
            this.setTicksPerWorkCycle(1);
            this.setEnergyPerWorkCycle(0);
        } else {
            this.setTicksPerWorkCycle(125);
            this.setEnergyPerWorkCycle(20320);
        }
        PacketItemStackDisplay packet = new PacketItemStackDisplay(this, this.getIndividualOnDisplay());
        Proxies.net.sendNetworkPacket(packet, this.worldObj);
    }

    public ItemStack getIndividualOnDisplay() {
        if (this.worldObj.isRemote) {
            return this.individualOnDisplayClient;
        }
        return this.getStackInSlot(0);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.tankManager.getTankInfo(from);
    }
}

