/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.network.IGuiHandler;
import forestry.core.GuiHandlerBase;
import forestry.core.circuits.ContainerSolderingIron;
import forestry.core.circuits.GuiSolderingIron;
import forestry.core.gui.ContainerAnalyzer;
import forestry.core.gui.ContainerEscritoire;
import forestry.core.gui.GuiAnalyzer;
import forestry.core.gui.GuiEscritoire;
import forestry.core.inventory.ItemInventorySolderingIron;
import forestry.core.network.GuiId;
import forestry.core.tiles.TileAnalyzer;
import forestry.core.tiles.TileEscritoire;
import forestry.core.tiles.TileUtil;
import forestry.plugins.PluginManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GuiHandler
extends GuiHandlerBase {
    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandler.decodeGuiID(id);
        if (cleanId < GuiId.values().length) {
            switch (GuiId.values()[cleanId]) {
                case AnalyzerGUI: {
                    return new GuiAnalyzer(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileAnalyzer.class));
                }
                case NaturalistBenchGUI: {
                    return new GuiEscritoire(player, TileUtil.getTile((IBlockAccess)world, x, y, z, TileEscritoire.class));
                }
                case SolderingIronGUI: {
                    ItemStack equipped = player.getCurrentEquippedItem();
                    if (equipped == null) {
                        return null;
                    }
                    return new GuiSolderingIron(player, new ItemInventorySolderingIron(player, equipped));
                }
            }
            for (IGuiHandler handler : PluginManager.guiHandlers) {
                Object element = handler.getClientGuiElement(id, player, world, x, y, z);
                if (element == null) continue;
                return element;
            }
            return null;
        }
        return null;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        int cleanId = GuiHandler.decodeGuiID(id);
        if (cleanId < GuiId.values().length) {
            switch (GuiId.values()[cleanId]) {
                case AnalyzerGUI: {
                    return new ContainerAnalyzer(player.inventory, TileUtil.getTile((IBlockAccess)world, x, y, z, TileAnalyzer.class));
                }
                case NaturalistBenchGUI: {
                    return new ContainerEscritoire(player, TileUtil.getTile((IBlockAccess)world, x, y, z, TileEscritoire.class));
                }
                case SolderingIronGUI: {
                    ItemStack equipped = player.getCurrentEquippedItem();
                    if (equipped == null) {
                        return null;
                    }
                    return new ContainerSolderingIron(player, new ItemInventorySolderingIron(player, equipped));
                }
            }
            for (IGuiHandler handler : PluginManager.guiHandlers) {
                Object element = handler.getServerGuiElement(id, player, world, x, y, z);
                if (element == null) continue;
                return element;
            }
            return null;
        }
        return null;
    }
}

