/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.Farmables;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.core.utils.ModUtil;
import forestry.farming.logic.FarmableGenericCrop;
import forestry.plugins.ForestryPlugin;
import forestry.plugins.Plugin;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

@Plugin(pluginID="ImmersiveEngineering", name="ImmersiveEngineering", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.immersiveengineering.description")
public class PluginImmersiveEngineering
extends ForestryPlugin {
    private static final String ImEng = "ImmersiveEngineering";

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(ImEng);
    }

    @Override
    public String getFailMessage() {
        return "Immersive Engineering not found";
    }

    @Override
    protected void registerRecipes() {
        ItemStack hempSeed = GameRegistry.findItemStack((String)ImEng, (String)"seed", (int)1);
        Block hempCrop = GameRegistry.findBlock((String)ImEng, (String)"hemp");
        ItemStack hempFiber = new ItemStack(GameRegistry.findItem((String)ImEng, (String)"material"), 1, 3);
        int seedAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        if (hempSeed != null && hempCrop != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{hempSeed}, Fluids.SEEDOIL.getFluid(seedAmount));
            Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(hempSeed, hempCrop, 4, hempFiber));
        }
    }
}

