/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import cpw.mods.fml.common.eventhandler.Event;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.GuiId;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.inventory.InventoryWorktable;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.ICrafterWorktable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;

public class TileWorktable
extends TileBase
implements ICrafterWorktable {
    private RecipeMemory.Recipe currentRecipe;
    private InventoryCrafting currentCrafting;
    private final RecipeMemory memorized;
    private final InventoryAdapterTile craftingInventory = new InventoryAdapterTile<TileWorktable>(this, 10, "CraftItems");

    public TileWorktable() {
        super(GuiId.WorktableGUI, "worktable");
        this.setInternalInventory(new InventoryWorktable(this));
        this.memorized = new RecipeMemory();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
        this.memorized.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
        this.memorized.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.craftingInventory.writeData(data);
        this.memorized.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.craftingInventory.readData(data);
        this.memorized.readData(data);
    }

    @Override
    public void validate() {
        super.validate();
        this.memorized.validate(this.worldObj);
    }

    public RecipeMemory getMemory() {
        return this.memorized;
    }

    public void chooseRecipe(int recipeIndex) {
        if (recipeIndex >= 9) {
            for (int slot = 0; slot < this.craftingInventory.getSizeInventory(); ++slot) {
                this.craftingInventory.setInventorySlotContents(slot, null);
            }
            return;
        }
        IInventory matrix = this.memorized.getRecipeMatrix(recipeIndex);
        if (matrix == null) {
            return;
        }
        for (int slot = 0; slot < matrix.getSizeInventory(); ++slot) {
            this.craftingInventory.setInventorySlotContents(slot, matrix.getStackInSlot(slot));
        }
    }

    public void setRecipe(InventoryCrafting crafting) {
        ItemStack recipeOutput = CraftingManager.getInstance().findMatchingRecipe(crafting, this.worldObj);
        if (recipeOutput == null) {
            this.currentRecipe = null;
            this.currentCrafting = null;
        } else {
            this.currentRecipe = new RecipeMemory.Recipe(crafting);
            this.currentCrafting = crafting;
        }
        this.updateCraftResult();
    }

    private void updateCraftResult() {
        ItemStack result;
        if (this.currentRecipe != null && (result = this.currentRecipe.getRecipeOutput(this.worldObj)) != null) {
            this.craftingInventory.setInventorySlotContents(9, result.copy());
            return;
        }
        this.craftingInventory.setInventorySlotContents(9, null);
    }

    private boolean canCraftCurrentRecipe() {
        if (this.currentRecipe == null) {
            return false;
        }
        ItemStack[] recipeItems = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        ItemStack[] inventory = InventoryUtil.getStacks((IInventory)this.getInternalInventory(), 0, 18);
        ItemStack recipeOutput = this.currentRecipe.getRecipeOutput(this.worldObj);
        return RecipeUtil.canCraftRecipe(this.worldObj, recipeItems, recipeOutput, inventory);
    }

    @Override
    public boolean canTakeStack(int slotIndex) {
        if (slotIndex == 9) {
            return this.canCraftCurrentRecipe();
        }
        return true;
    }

    @Override
    public boolean onCraftingStart(EntityPlayer player) {
        InventoryMapper inventory = new InventoryMapper((IInventory)this, 0, 18);
        ItemStack[] set = InventoryUtil.getStacks((IInventory)this.currentRecipe.getMatrix());
        ItemStack[] removed = InventoryUtil.removeSets(inventory, 1, set, player, false, true, true);
        if (removed == null) {
            return false;
        }
        for (int i = 0; i < removed.length; ++i) {
            this.craftingInventory.setInventorySlotContents(i, removed[i]);
        }
        return true;
    }

    @Override
    public void onCraftingComplete(EntityPlayer player) {
        IInventory craftingInventory = this.getCraftingInventory();
        for (int i = 0; i < craftingInventory.getSizeInventory(); ++i) {
            ItemStack itemStack = craftingInventory.getStackInSlot(i);
            if (itemStack == null) continue;
            ItemStack container = null;
            if (itemStack.getItem().hasContainerItem(itemStack)) {
                container = itemStack.getItem().getContainerItem(itemStack);
            } else if (itemStack.stackSize > 1) {
                container = ItemStackUtil.createSplitStack(itemStack, itemStack.stackSize - 1);
                itemStack.stackSize = 1;
            }
            if (container == null) continue;
            if (container != null && container.isItemStackDamageable() && container.getItemDamage() > container.getMaxDamage()) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(player, container));
                continue;
            }
            if (InventoryUtil.tryAddStack((IInventory)this, container, true)) continue;
            player.dropPlayerItemWithRandomChoice(container, false);
        }
        if (!this.worldObj.isRemote) {
            this.memorized.memorizeRecipe(this.worldObj, this.currentRecipe, this.currentCrafting);
        }
        this.updateCraftResult();
    }

    @Override
    public ItemStack getResult() {
        if (this.currentRecipe == null) {
            return null;
        }
        if (this.currentRecipe.getRecipeOutput(this.worldObj) != null) {
            return this.currentRecipe.getRecipeOutput(this.worldObj).copy();
        }
        return null;
    }

    public IInventory getCraftingInventory() {
        return new InventoryMapper((IInventory)this.craftingInventory, 0, 9);
    }
}

