/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import com.google.common.collect.ArrayListMultimap;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.circuits.SolderManager;
import forestry.core.items.ItemOverlay;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class ItemElectronTube
extends ItemOverlay {
    public ItemElectronTube(CreativeTabs tab, ItemOverlay.OverlayInfo ... overlays) {
        super(tab, overlays);
    }

    public void addInformation(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        ArrayListMultimap circuits = ArrayListMultimap.create();
        for (ICircuitLayout circuitLayout : ChipsetManager.circuitRegistry.getRegisteredLayouts().values()) {
            ICircuit circuit = SolderManager.getCircuit(circuitLayout, itemstack);
            if (circuit == null) continue;
            circuits.put((Object)circuitLayout, (Object)circuit);
        }
        if (circuits.size() > 0) {
            if (Proxies.common.isShiftDown()) {
                for (ICircuitLayout circuitLayout : circuits.keys()) {
                    String circuitLayoutName = circuitLayout.getUsage();
                    list.add(EnumChatFormatting.WHITE.toString() + EnumChatFormatting.UNDERLINE + circuitLayoutName);
                    for (ICircuit circuit : circuits.get((Object)circuitLayout)) {
                        circuit.addTooltip(list);
                    }
                }
            } else {
                list.add(EnumChatFormatting.ITALIC + "<" + StringUtil.localize("gui.tooltip.tmi") + ">");
            }
        } else {
            list.add("<" + StringUtil.localize("gui.noeffect") + ">");
        }
    }
}

