/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.triggers;

import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import forestry.core.triggers.Trigger;
import forestry.core.utils.InventoryUtil;
import forestry.farming.tiles.TileHatch;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerLowGermlings
extends Trigger {
    private final float threshold;

    public TriggerLowGermlings(String tag, float threshold) {
        super(tag, "lowGermlings");
        this.threshold = threshold;
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " < " + this.threshold * 100.0f + "%";
    }

    public boolean isTriggerActive(TileEntity tile, ForgeDirection side, IStatementContainer source, IStatementParameter[] parameters) {
        if (!(tile instanceof TileHatch)) {
            return false;
        }
        TileHatch tileHatch = (TileHatch)tile;
        IInventory germlingsInventory = tileHatch.getFarmController().getFarmInventory().getGermlingsInventory();
        return InventoryUtil.containsPercent(germlingsInventory, this.threshold);
    }
}

