/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.multiblock;

import forestry.api.core.BiomeHelper;
import forestry.api.core.INBTTagable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.tiles.IClimatised;
import forestry.farming.gui.IFarmLedgerDelegate;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class FarmHydrationManager
implements IFarmLedgerDelegate,
INBTTagable,
IStreamable {
    private static final int DELAY_HYDRATION = 100;
    private static final float RAINFALL_MODIFIER_MAX = 15.0f;
    private static final float RAINFALL_MODIFIER_MIN = 0.5f;
    private final IClimatised climatised;
    private int hydrationDelay = 0;
    private int ticksSinceRainfall = 0;

    public FarmHydrationManager(IClimatised climatised) {
        this.climatised = climatised;
    }

    public void updateServer(World world, BiomeGenBase biome) {
        if (world.isRaining() && BiomeHelper.canRainOrSnow(biome)) {
            if (this.hydrationDelay > 0) {
                --this.hydrationDelay;
            } else {
                this.ticksSinceRainfall = 0;
            }
        } else {
            this.hydrationDelay = 100;
            if (this.ticksSinceRainfall < Integer.MAX_VALUE) {
                ++this.ticksSinceRainfall;
            }
        }
    }

    @Override
    public float getHydrationModifier() {
        return this.getHydrationTempModifier() * this.getHydrationHumidModifier() * this.getHydrationRainfallModifier();
    }

    @Override
    public float getHydrationTempModifier() {
        float temperature = this.climatised.getExactTemperature();
        return temperature > 0.8f ? temperature : 0.8f;
    }

    @Override
    public float getHydrationHumidModifier() {
        float mod = 1.0f / this.climatised.getExactHumidity();
        return mod < 2.0f ? mod : 2.0f;
    }

    @Override
    public float getHydrationRainfallModifier() {
        float mod = (float)this.ticksSinceRainfall / 24000.0f;
        if (mod <= 0.5f) {
            return 0.5f;
        }
        if (mod >= 15.0f) {
            return 15.0f;
        }
        return mod;
    }

    @Override
    public double getDrought() {
        return (double)Math.round((double)this.ticksSinceRainfall / 24000.0 * 10.0) / 10.0;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.hydrationDelay = nbttagcompound.getInteger("HydrationDelay");
        this.ticksSinceRainfall = nbttagcompound.getInteger("TicksSinceRainfall");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setInteger("HydrationDelay", this.hydrationDelay);
        nbttagcompound.setInteger("TicksSinceRainfall", this.ticksSinceRainfall);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.hydrationDelay);
        data.writeVarInt(this.ticksSinceRainfall);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.hydrationDelay = data.readVarInt();
        this.ticksSinceRainfall = data.readVarInt();
    }
}

