/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketEntityUpdate;
import forestry.core.network.PacketIdClient;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

public class PacketAccessUpdateEntity
extends PacketEntityUpdate
implements IForestryPacketClient {
    private IAccessHandler accessHandler;

    public PacketAccessUpdateEntity() {
    }

    public PacketAccessUpdateEntity(IRestrictedAccess restrictedAccess, Entity entity) {
        super(PacketIdClient.ACCESS_UPDATE_ENTITY, entity);
        this.accessHandler = restrictedAccess.getAccessHandler();
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.accessHandler.writeData(data);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        Entity tile = this.getTarget(player.worldObj);
        if (tile instanceof IRestrictedAccess) {
            IRestrictedAccess restrictedAccessTile = (IRestrictedAccess)tile;
            restrictedAccessTile.getAccessHandler().readData(data);
        }
    }
}

