/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.entities;

import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class EntityFXSnow
extends EntityFX {
    public static IIcon[] icons;

    public EntityFXSnow(World world, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.setParticleIcon(icons[this.rand.nextInt(icons.length)]);
        this.particleScale *= 0.5f;
        this.particleMaxAge = (int)(40.0 / (Math.random() * 0.8 + 0.2));
        this.noClip = true;
        this.motionX *= 0.01;
        this.motionY *= -0.4;
        this.motionZ *= 0.01;
    }

    public int getFXLayer() {
        return 2;
    }

    public void renderParticle(Tessellator tess, float timeStep, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        double x = this.prevPosX + (this.posX - this.prevPosX) * (double)timeStep - interpPosX;
        double y = this.prevPosY + (this.posY - this.prevPosY) * (double)timeStep - interpPosY;
        double z = this.prevPosZ + (this.posZ - this.prevPosZ) * (double)timeStep - interpPosZ;
        float minU = (float)this.particleTextureIndexX / 16.0f;
        float maxU = minU + 0.0624375f;
        float minV = (float)this.particleTextureIndexY / 16.0f;
        float maxV = minV + 0.0624375f;
        float scale = 0.1f * this.particleScale;
        if (this.particleIcon != null) {
            minU = this.particleIcon.getMinU();
            maxU = this.particleIcon.getMaxU();
            minV = this.particleIcon.getMinV();
            maxV = this.particleIcon.getMaxV();
        }
        tess.setColorRGBA_F(this.particleRed, this.particleGreen, this.particleBlue, this.particleAlpha);
        for (int i = 0; i < 5; ++i) {
            EntityFXSnow.renderParticle(tess, x, y, z, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY, minU, maxU, minV, maxV, scale);
        }
    }

    private static void renderParticle(Tessellator tess, double x, double y, double z, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY, float minU, float maxU, float minV, float maxV, float scale) {
        tess.addVertexWithUV(x - (double)(rotationX * scale) - (double)(rotationYZ * scale), y - (double)(rotationXZ * scale), z - (double)(rotationZ * scale) - (double)(rotationXY * scale), (double)maxU, (double)maxV);
        tess.addVertexWithUV(x - (double)(rotationX * scale) + (double)(rotationYZ * scale), y + (double)(rotationXZ * scale), z - (double)(rotationZ * scale) + (double)(rotationXY * scale), (double)maxU, (double)minV);
        tess.addVertexWithUV(x + (double)(rotationX * scale) + (double)(rotationYZ * scale), y + (double)(rotationXZ * scale), z + (double)(rotationZ * scale) + (double)(rotationXY * scale), (double)minU, (double)minV);
        tess.addVertexWithUV(x + (double)(rotationX * scale) - (double)(rotationYZ * scale), y - (double)(rotationXZ * scale), z + (double)(rotationZ * scale) - (double)(rotationXY * scale), (double)minU, (double)maxV);
    }
}

