/*
 * Decompiled with CFR 0.152.
 */
package forestry.food.inventory;

import forestry.api.food.BeverageManager;
import forestry.core.config.ForestryItem;
import forestry.core.inventory.ItemInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemInventoryInfuser
extends ItemInventory {
    private static final short inputSlot = 0;
    private static final short outputSlot = 1;
    private static final short ingredientSlot1 = 2;
    private static final short ingredientSlotCount = 4;

    public ItemInventoryInfuser(EntityPlayer player, ItemStack itemStack) {
        super(player, 6, itemStack);
    }

    @Override
    public void onSlotClick(EntityPlayer player) {
        ItemStack[] toRemove;
        ItemStack input = this.getStackInSlot(0);
        if (input == null) {
            return;
        }
        if (this.getStackInSlot(1) != null) {
            return;
        }
        if (!input.isItemEqual(ForestryItem.beverage.getItemStack())) {
            return;
        }
        ItemStack[] ingredients = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            ingredients[i] = this.getStackInSlot(i + 2);
        }
        if (!BeverageManager.infuserManager.hasMixtures(ingredients)) {
            return;
        }
        ItemStack seasoned = BeverageManager.infuserManager.getSeasoned(input, ingredients);
        if (seasoned == null) {
            return;
        }
        block1: for (ItemStack templ : toRemove = BeverageManager.infuserManager.getRequired(ingredients)) {
            ItemStack ghost = templ.copy();
            for (int i = 2; i < this.getSizeInventory(); ++i) {
                ItemStack ingredient = this.getStackInSlot(i);
                if (ingredient == null) continue;
                if (ghost.stackSize <= 0) continue block1;
                if ((ghost.getItemDamage() < 0 || !ingredient.isItemEqual(ghost)) && (ghost.getItemDamage() >= 0 || ghost.getItem() != ingredient.getItem())) continue;
                ItemStack removed = this.decrStackSize(i, 1);
                ghost.stackSize -= removed.stackSize;
            }
        }
        this.decrStackSize(0, 1);
        this.setInventorySlotContents(1, seasoned);
    }

    @Override
    public String getInventoryName() {
        return "Infuser";
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (slotIndex == 0) {
            return ForestryItem.beverage.isItemEqual(itemStack);
        }
        if (slotIndex >= 2 && slotIndex < 6) {
            return BeverageManager.infuserManager.isIngredient(itemStack);
        }
        return false;
    }
}

