/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.IErrorState;
import forestry.core.access.EnumAccess;
import forestry.core.access.FakeAccessHandler;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.gui.ContainerForestry;
import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketAccessUpdate;
import forestry.core.network.PacketErrorUpdate;
import forestry.core.network.PacketGuiEnergy;
import forestry.core.network.PacketGuiUpdate;
import forestry.core.tiles.IPowerHandler;
import forestry.core.tiles.TilePowered;
import forestry.core.tiles.TileUtil;
import forestry.energy.EnergyManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public abstract class ContainerTile<T extends TileEntity>
extends ContainerForestry {
    protected final T tile;
    private final IAccessHandler accessHandler;
    private ImmutableSet<IErrorState> previousErrorStates;
    private int previousEnergyManagerData = 0;
    private EnumAccess previousAccess;
    private int previousWorkCounter = 0;
    private int previousTicksPerWorkCycle = 0;

    protected ContainerTile(T tile) {
        this.tile = tile;
        this.accessHandler = tile instanceof IRestrictedAccess ? ((IRestrictedAccess)tile).getAccessHandler() : FakeAccessHandler.getInstance();
    }

    protected ContainerTile(T tileForestry, InventoryPlayer playerInventory, int xInv, int yInv) {
        this(tileForestry);
        this.addPlayerInventory(playerInventory, xInv, yInv);
    }

    @Override
    protected final boolean canAccess(EntityPlayer player) {
        return player != null && this.accessHandler.allowsAlteration(player);
    }

    public final boolean canInteractWith(EntityPlayer entityplayer) {
        return TileUtil.isUsableByPlayer(entityplayer, this.tile) && this.accessHandler.allowsViewing(entityplayer);
    }

    public void detectAndSendChanges() {
        IRestrictedAccess restrictedAccess;
        IAccessHandler accessHandler;
        EnumAccess access;
        EnergyManager energyManager;
        int energyManagerData;
        ForestryPacket packet;
        super.detectAndSendChanges();
        if (this.tile instanceof IErrorLogicSource) {
            IErrorLogicSource errorLogicSource = (IErrorLogicSource)this.tile;
            ImmutableSet<IErrorState> errorStates = errorLogicSource.getErrorLogic().getErrorStates();
            if (this.previousErrorStates == null || !errorStates.equals(this.previousErrorStates)) {
                packet = new PacketErrorUpdate((TileEntity)this.tile, errorLogicSource);
                this.sendPacketToCrafters((IForestryPacketClient)((Object)packet));
            }
            this.previousErrorStates = errorStates;
        }
        if (this.tile instanceof IPowerHandler && (energyManagerData = (energyManager = ((IPowerHandler)this.tile).getEnergyManager()).toGuiInt()) != this.previousEnergyManagerData) {
            packet = new PacketGuiEnergy(this.windowId, energyManagerData);
            this.sendPacketToCrafters((IForestryPacketClient)((Object)packet));
            this.previousEnergyManagerData = energyManagerData;
        }
        if (this.tile instanceof IRestrictedAccess && (access = (accessHandler = (restrictedAccess = (IRestrictedAccess)this.tile).getAccessHandler()).getAccess()) != this.previousAccess) {
            PacketAccessUpdate packet2 = new PacketAccessUpdate(restrictedAccess, (TileEntity)this.tile);
            this.sendPacketToCrafters(packet2);
            this.previousAccess = access;
        }
        if (this.tile instanceof TilePowered) {
            int ticksPerWorkCycle;
            boolean guiNeedsUpdate = false;
            TilePowered tilePowered = (TilePowered)this.tile;
            int workCounter = tilePowered.getWorkCounter();
            if (workCounter != this.previousWorkCounter) {
                guiNeedsUpdate = true;
                this.previousWorkCounter = workCounter;
            }
            if ((ticksPerWorkCycle = tilePowered.getTicksPerWorkCycle()) != this.previousTicksPerWorkCycle) {
                guiNeedsUpdate = true;
                this.previousTicksPerWorkCycle = ticksPerWorkCycle;
            }
            if (guiNeedsUpdate) {
                PacketGuiUpdate packet3 = new PacketGuiUpdate(tilePowered);
                this.sendPacketToCrafters(packet3);
            }
        }
    }

    public void onGuiEnergy(int energyStored) {
        if (this.tile instanceof IPowerHandler) {
            EnergyManager energyManager = ((IPowerHandler)this.tile).getEnergyManager();
            energyManager.fromGuiInt(energyStored);
        }
    }
}

