/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.core.ForestryAPI;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.access.AccessHandler;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IRestrictedAccess;
import forestry.core.network.GuiId;
import forestry.core.tiles.ITitled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;

public abstract class TileAlvearyWithGui
extends TileAlveary
implements ITitled,
IRestrictedAccess {
    private final AccessHandler accessHandler = new AccessHandler(this);
    private final String unlocalizedTitle;
    private final GuiId guiId;

    protected TileAlvearyWithGui(int meta, GuiId guiId) {
        this.unlocalizedTitle = "tile.for.alveary." + meta + ".name";
        this.guiId = guiId;
    }

    @Override
    public final IAccessHandler getAccessHandler() {
        return this.accessHandler;
    }

    @Override
    public final ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void onSwitchAccess(EnumAccess oldAccess, EnumAccess newAccess) {
        if (oldAccess == EnumAccess.SHARED || newAccess == EnumAccess.SHARED) {
            this.worldObj.notifyBlocksOfNeighborChange(this.xCoord, this.yCoord, this.zCoord, this.blockType);
            this.markDirty();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.accessHandler.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.accessHandler.readFromNBT(data);
    }

    @Override
    public final String getUnlocalizedTitle() {
        return this.unlocalizedTitle;
    }

    @Override
    public final void openGui(EntityPlayer player) {
        player.openGui(ForestryAPI.instance, this.guiId.ordinal(), this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }
}

