/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.inventory;

import forestry.api.apiculture.IHiveFrame;
import forestry.apiculture.inventory.InventoryTileBeeHousing;
import forestry.apiculture.tiles.TileApiary;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.utils.SlotUtil;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class InventoryApiary
extends InventoryTileBeeHousing {
    public static final int SLOT_FRAMES_1 = 9;
    public static final int SLOT_FRAMES_COUNT = 3;

    public InventoryApiary(TileApiary tile) {
        super(tile, 12, "Items");
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        if (SlotUtil.isSlotInRange(slotIndex, 9, 3)) {
            return itemStack.getItem() instanceof IHiveFrame && this.getStackInSlot(slotIndex) == null;
        }
        return super.canSlotAccept(slotIndex, itemStack);
    }

    @Override
    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        if (SlotUtil.isSlotInRange(slotIndex, 9, 3)) {
            return false;
        }
        return super.isItemValidForSlot(slotIndex, itemStack);
    }

    public IInventory getFrameInventory() {
        return new InventoryMapper((IInventory)this, 9, 3);
    }

    public Collection<IHiveFrame> getFrames() {
        ArrayList<IHiveFrame> hiveFrames = new ArrayList<IHiveFrame>(3);
        for (int i = 9; i < 12; ++i) {
            Item itemInSlot;
            ItemStack stackInSlot = this.getStackInSlot(i);
            if (stackInSlot == null || !((itemInSlot = stackInSlot.getItem()) instanceof IHiveFrame)) continue;
            hiveFrames.add((IHiveFrame)itemInSlot);
        }
        return hiveFrames;
    }
}

